/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.Context;
import jdave.runner.ExecutingBehavior;
import jdave.runner.ISpecVisitor;
import jdave.runner.VisitingBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecRunner {
    public <T extends Specification<?>> void visit(Class<T> specType, ISpecVisitor callback) {
        Class<?>[] classArray = this.getDeclaredClasses(specType);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> contextType = classArray[n2];
            Context context = new Context(specType, contextType){

                @Override
                protected Behavior newBehavior(Method method, Class<? extends Specification<?>> specType, Class<?> contextType) {
                    return new VisitingBehavior(method);
                }
            };
            this.run(callback, context);
            ++n2;
        }
    }

    public <T extends Specification<?>> void run(Class<T> specType, ISpecVisitor callback) {
        Class<?>[] classArray = this.getDeclaredClasses(specType);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> contextType = classArray[n2];
            Context context = new Context(specType, contextType){

                @Override
                protected Behavior newBehavior(Method method, Class<? extends Specification<?>> specType, Class<?> contextType) {
                    return new ExecutingBehavior(method, specType, contextType);
                }
            };
            this.run(callback, context);
            ++n2;
        }
    }

    private Class<?>[] getDeclaredClasses(Class<?> specType) {
        return SpecRunner.reverse(specType.getDeclaredClasses());
    }

    private static Class<?>[] reverse(Class<?>[] classes) {
        int i = 0;
        while (i < classes.length / 2) {
            Class<?> tmp = classes[i];
            classes[i] = classes[classes.length - 1 - i];
            classes[classes.length - 1 - i] = tmp;
            ++i;
        }
        return classes;
    }

    private void run(ISpecVisitor callback, Context context) {
        if (context.isContextClass()) {
            callback.onContext(context);
            context.run(callback);
            callback.afterContext(context);
        }
    }
}

