/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.util.Collection;
import jdave.runner.Groups;
import jdave.support.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolution {
    private final Groups groups;

    public Resolution(Groups groups) {
        Assert.notNull(groups, "must include @Groups annotation");
        this.groups = groups;
    }

    public boolean includes(Collection<String> groupsToCheck) {
        String[] stringArray = this.groups.include();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String groupToInclude = stringArray[n2];
            if (this.includes(groupsToCheck, groupToInclude)) {
                return !this.excludes(groupsToCheck);
            }
            ++n2;
        }
        return false;
    }

    private boolean excludes(Collection<String> groupsToCheck) {
        String[] stringArray = this.groups.exclude();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String groupToExclude = stringArray[n2];
            if (groupToExclude.equals("__all_groups")) {
                return true;
            }
            if (groupsToCheck.contains(groupToExclude)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean includes(Collection<String> groupsToCheck, String groupToInclude) {
        if (groupToInclude.equals("__all_groups")) {
            return true;
        }
        return groupsToCheck.contains(groupToInclude);
    }
}

