/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.DefaultSpecIntrospection;
import jdave.runner.ISpecIntrospection;
import jdave.runner.ISpecVisitor;
import jdave.runner.IntrospectionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Context {
    private final Class<? extends Specification<?>> specType;
    private final Class<?> contextType;

    public Context(Class<? extends Specification<?>> specType, Class<?> contextType) {
        this.specType = specType;
        this.contextType = contextType;
    }

    public String getName() {
        return this.contextType.getSimpleName();
    }

    protected abstract Behavior newBehavior(Method var1, Class<? extends Specification<?>> var2, Class<?> var3);

    void run(ISpecVisitor callback) {
        for (Method method : this.contextType.getMethods()) {
            if (!this.isBehavior(method)) continue;
            callback.onBehavior(this.newBehavior(method, this.specType, this.contextType));
        }
    }

    private boolean isBehavior(Method method) {
        return this.newIntrospection().isBehavior(method);
    }

    public boolean isContextClass() {
        return this.newIntrospection().isContextClass(this.specType, this.contextType);
    }

    private ISpecIntrospection newIntrospection() {
        try {
            IntrospectionStrategy strategy = this.specType.getAnnotation(IntrospectionStrategy.class);
            if (strategy != null) {
                return strategy.value().newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new DefaultSpecIntrospection();
    }
}

