/*
 * Decompiled with CFR 0.152.
 */
package jdave.jemmy;

import java.awt.Container;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import jdave.DefaultLifecycleListener;
import jdave.ExpectationFailedException;
import jdave.ILifecycleListener;
import jdave.Specification;
import jdave.jemmy.IContainerContainment;
import jdave.jemmy.JLabelContainment;
import jdave.jemmy.NoSuchButtonException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JFrameOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JemmyContainerSpecification<T extends Container>
extends Specification<T> {
    protected JemmyOperations jemmy = new JemmyOperations();
    protected JFrameOperator frame;
    protected T container;

    public JemmyContainerSpecification() {
        this.initJemmy();
        this.addListener((ILifecycleListener)new DefaultLifecycleListener(){

            public void afterContextInstantiation(Object contextInstance) {
                JemmyContainerSpecification.this.frame = new JFrameOperator(new JFrame());
                JemmyContainerSpecification.this.frame.setDefaultCloseOperation(2);
            }

            public void afterContextDestroy(Object contextInstance) {
                JemmyContainerSpecification.this.frame.close();
            }
        });
    }

    protected void initJemmy() {
        InputStream timeouts = this.getTimeouts();
        try {
            JemmyProperties.getCurrentTimeouts().load(timeouts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected InputStream getTimeouts() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jdave-jemmy.timeouts");
    }

    protected abstract T newContainer();

    protected T startContainer() {
        this.container = this.newContainer();
        this.frame.add(this.container);
        this.frame.setVisible(true);
        this.frame.pack();
        this.jemmy.queue.waitEmpty();
        return this.container;
    }

    public void specify(IContainerContainment containment) {
        if (!containment.isIn((Container)this.container)) {
            throw new ExpectationFailedException(containment.error((Container)this.container));
        }
    }

    public IContainerContainment containsLabel(String expected) {
        return new JLabelContainment(expected);
    }

    protected class JemmyOperations {
        public QueueTool queue = new QueueTool();

        protected JemmyOperations() {
        }

        public void pushButton(String text) {
            JButton button = JButtonOperator.findJButton(JemmyContainerSpecification.this.container, (String)text, (boolean)true, (boolean)true);
            if (button == null) {
                throw new NoSuchButtonException(text);
            }
            new JButtonOperator(button).push();
        }
    }
}

