/*
 * Decompiled with CFR 0.152.
 */
package jdave.jemmy;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import jdave.jemmy.IContainerContainment;
import org.netbeans.jemmy.operators.JLabelOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JLabelContainment
implements IContainerContainment {
    private final String expected;

    public JLabelContainment(String expected) {
        this.expected = expected;
    }

    @Override
    public boolean isIn(Container container) {
        JLabel label = JLabelOperator.findJLabel((Container)container, (String)this.expected, (boolean)true, (boolean)true);
        return label != null;
    }

    @Override
    public String error(Container container) {
        List<JLabel> labels = this.findLabels(container);
        if (labels.isEmpty()) {
            return "Expected label with text \"" + this.expected + "\", but there are no labels in container.";
        }
        return "Expected label with text \"" + this.expected + "\", but container has only the following labels: " + this.format(labels) + ".";
    }

    private List<JLabel> findLabels(Container container) {
        ArrayList<JLabel> results = new ArrayList<JLabel>();
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JLabel) {
                results.add((JLabel)component);
            }
            if (component instanceof Container) {
                results.addAll(this.findLabels((Container)component));
            }
            ++n2;
        }
        return results;
    }

    private String format(List<JLabel> labels) {
        ArrayList<String> result = new ArrayList<String>();
        for (JLabel label : labels) {
            result.add(label.getText());
        }
        return ((Object)result).toString();
    }
}

