/*
 * Decompiled with CFR 0.152.
 */
package org.laughingpanda.beaninject;

import org.laughingpanda.beaninject.IDependencyInjector;
import org.laughingpanda.beaninject.IInjectionStrategy;
import org.laughingpanda.beaninject.IStaticTargetIdentifier;
import org.laughingpanda.beaninject.ITargetIdentifier;
import org.laughingpanda.beaninject.ITargetInjector;
import org.laughingpanda.beaninject.impl.FieldInjector;
import org.laughingpanda.beaninject.impl.MethodInjector;
import org.laughingpanda.beaninject.impl.StaticFieldInjector;
import org.laughingpanda.beaninject.impl.TypeBasedInjector;

public class Inject {
    public static ITargetIdentifier field(final String fieldName) {
        return new ITargetIdentifier(){

            public IDependencyInjector of(Object target) {
                return new FieldInjector(target, fieldName);
            }
        };
    }

    public static IStaticTargetIdentifier staticField(final String fieldName) {
        return new IStaticTargetIdentifier(){

            public IDependencyInjector of(Class target) {
                return new StaticFieldInjector(target, fieldName);
            }
        };
    }

    public static ITargetIdentifier property(final String propertyName) {
        return new ITargetIdentifier(){

            public IDependencyInjector of(Object target) {
                String methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                return new MethodInjector(target, methodName);
            }
        };
    }

    public static IDependencyInjector bean(final Object target) {
        return new IDependencyInjector(){

            public void with(Object dependency) {
                new TypeBasedInjector().inject(target, dependency);
            }
        };
    }

    public static ITargetInjector with(final IInjectionStrategy strategy) {
        return new ITargetInjector(){

            public void bean(Object target) {
                strategy.inject(target);
            }
        };
    }
}

