/*
 * Decompiled with CFR 0.152.
 */
package org.laughingpanda.beaninject.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accessor {
    public static List<Method> methods(Class clazz) {
        Method[] declared = clazz.getDeclaredMethods();
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(declared));
        if (clazz.getSuperclass() != null) {
            methods.addAll(Accessor.methods(clazz.getSuperclass()));
        }
        return methods;
    }

    public static List<Field> fields(Class clazz) {
        Field[] declared = clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(declared));
        if (clazz.getSuperclass() != null) {
            fields.addAll(Accessor.fields(clazz.getSuperclass()));
        }
        return fields;
    }

    public static Field field(String name, Class clazz) {
        for (Field field : Accessor.fields(clazz)) {
            if (!field.getName().equals(name)) continue;
            return Accessor.makeAccessible(field);
        }
        return null;
    }

    private static Field makeAccessible(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    public static List<Field> fieldsAssignableFrom(Class<?> type, Class<?> target) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : Accessor.fields(target)) {
            if (!field.getType().isAssignableFrom(type)) continue;
            fields.add(field);
        }
        return fields;
    }
}

