/*
 * Decompiled with CFR 0.152.
 */
package org.laughingpanda.beaninject.impl;

import java.lang.reflect.Method;
import java.util.List;
import org.laughingpanda.beaninject.impl.AbstractObjectInjector;
import org.laughingpanda.beaninject.impl.Accessor;
import org.laughingpanda.beaninject.impl.Autobox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjector
extends AbstractObjectInjector {
    public MethodInjector(Object target, String name) {
        super(target, name);
    }

    @Override
    public void with(Object dependency) {
        this.inject(dependency, Accessor.methods(this.target.getClass()));
    }

    private void inject(Object dependency, List<Method> accessors) {
        for (Method accessor : accessors) {
            if (!this.match(accessor, dependency.getClass())) continue;
            this.inject(dependency, accessor);
            return;
        }
        throw new RuntimeException("No method on " + this.target.getClass().getName() + " matched name \"" + this.name + "\" and type " + dependency.getClass().getName());
    }

    private boolean match(Method accessor, Class actualType) {
        if (!accessor.getName().equals(this.name)) {
            return false;
        }
        Class<?>[] parameters = accessor.getParameterTypes();
        if (parameters.length != 1) {
            return false;
        }
        Class<?> expectedType = Autobox.toPrimitive(parameters[0]);
        return expectedType.isAssignableFrom(Autobox.toPrimitive(actualType));
    }

    private void inject(Object dependency, Method accessor) {
        try {
            if (!accessor.isAccessible()) {
                accessor.setAccessible(true);
            }
            accessor.invoke(this.target, dependency);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to inject to method", e);
        }
    }
}

