/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import java.io.File;
import java.lang.reflect.Method;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class SeleneseTestCase
extends TestCase {
    private static final boolean THIS_IS_WINDOWS = File.pathSeparator.equals(";");
    protected Selenium selenium;
    private StringBuffer verificationErrors = new StringBuffer();

    public void setUp() throws Exception {
        super.setUp();
        this.setUp(null);
    }

    public void setUp(String url) throws Exception {
        if (THIS_IS_WINDOWS) {
            this.setUp(url, "*iexplore");
        } else {
            this.setUp(url, "*firefox");
        }
    }

    public void setUp(String url, String browserString) throws Exception {
        super.setUp();
        int port = this.getDefaultPort();
        if (url == null) {
            url = "http://localhost:" + port;
        }
        this.selenium = new DefaultSelenium("localhost", port, browserString, url);
        this.selenium.start();
    }

    private int getDefaultPort() {
        try {
            Class<?> c = Class.forName("org.openqa.selenium.server.SeleniumServer");
            Method getDefaultPort = c.getMethod("getDefaultPort", new Class[0]);
            Integer portNumber = (Integer)getDefaultPort.invoke(null, new Object[0]);
            return portNumber;
        }
        catch (Exception e) {
            return 4444;
        }
    }

    public void verifyTrue(boolean b) {
        try {
            SeleneseTestCase.assertTrue((boolean)b);
        }
        catch (AssertionFailedError e) {
            this.verificationErrors.append((Object)e);
        }
    }

    public void verifyFalse(boolean b) {
        try {
            SeleneseTestCase.assertFalse((boolean)b);
        }
        catch (AssertionFailedError e) {
            this.verificationErrors.append((Object)e);
        }
    }

    public String getText() {
        return this.selenium.getEval("this.page().bodyText()");
    }

    public void verifyEquals(Object s1, Object s2) {
        try {
            SeleneseTestCase.assertEquals(s1, s2);
        }
        catch (AssertionFailedError e) {
            this.verificationErrors.append((Object)e);
        }
    }

    public void verifyEquals(boolean s1, boolean s2) {
        try {
            SeleneseTestCase.assertEquals(new Boolean(s1), new Boolean(s2));
        }
        catch (AssertionFailedError e) {
            this.verificationErrors.append((Object)e);
        }
    }

    public static void assertEquals(Object s1, Object s2) {
        if (s1 instanceof String && s2 instanceof String) {
            SeleneseTestCase.assertEquals((String)s1, (String)s2);
        } else if (s1 instanceof String && s2 instanceof String[]) {
            SeleneseTestCase.assertEquals((String)s1, (String[])s2);
        } else if (s1 instanceof String && s2 instanceof Number) {
            SeleneseTestCase.assertEquals((String)s1, ((Number)s2).toString());
        } else if (s1 instanceof String[] && s2 instanceof String[]) {
            String[] sa1 = (String[])s1;
            String[] sa2 = (String[])s2;
            if (sa1.length != sa2.length) {
                throw new AssertionFailedError("Expected " + sa1 + " but saw " + sa2);
            }
            for (int j = 0; j < sa1.length; ++j) {
                Assert.assertEquals((String)sa1[j], (String)sa2[j]);
            }
        }
    }

    public static void assertEquals(String s1, String s2) {
        SeleneseTestCase.assertTrue((String)("Expected \"" + s1 + "\" but saw \"" + s2 + "\" instead"), (boolean)SeleneseTestCase.seleniumEquals(s1, s2));
    }

    public static void assertEquals(String s1, String[] s2) {
        SeleneseTestCase.assertEquals(s1, SeleneseTestCase.stringArrayToSimpleString(s2));
    }

    public static boolean seleniumEquals(String expectedPattern, String actual) {
        String expectedRegEx;
        if (actual.startsWith("regexp:") || actual.startsWith("regex:")) {
            String tmp = actual;
            actual = expectedPattern;
            expectedPattern = tmp;
        }
        if (expectedPattern.startsWith("regexp:")) {
            expectedRegEx = expectedPattern.replaceFirst("regexp:", ".*") + ".*";
            if (!actual.matches(expectedRegEx)) {
                System.out.println("expected " + actual + " to match regexp " + expectedPattern);
                return false;
            }
            return true;
        }
        if (expectedPattern.startsWith("regex:")) {
            expectedRegEx = expectedPattern.replaceFirst("regex:", ".*") + ".*";
            if (!actual.matches(expectedRegEx)) {
                System.out.println("expected " + actual + " to match regex " + expectedPattern);
                return false;
            }
            return true;
        }
        if (expectedPattern.startsWith("exact:")) {
            String expectedExact = expectedPattern.replaceFirst("exact:", "");
            if (!expectedExact.equals(actual)) {
                System.out.println("expected " + actual + " to match " + expectedPattern);
                return false;
            }
            return true;
        }
        String expectedGlob = expectedPattern.replaceFirst("glob:", "");
        expectedGlob = expectedGlob.replaceAll("([\\]\\[\\\\{\\}$\\(\\)\\|\\^\\+.])", "\\\\$1");
        expectedGlob = expectedGlob.replaceAll("\\*", "(.|[\r\n])*");
        if (!actual.matches(expectedGlob = expectedGlob.replaceAll("\\?", "(.|[\r\n])"))) {
            System.out.println("expected \"" + actual + "\" to match glob \"" + expectedPattern + "\" (had transformed the glob into regexp \"" + expectedGlob + "\"");
            return false;
        }
        return true;
    }

    public static boolean seleniumEquals(Object expected, Object actual) {
        if (expected instanceof String && actual instanceof String) {
            return SeleneseTestCase.seleniumEquals((String)expected, (String)actual);
        }
        return expected.equals(actual);
    }

    public static void assertEquals(String[] s1, String[] s2) {
        String comparisonDumpIfNotEqual = SeleneseTestCase.verifyEqualsAndReturnComparisonDumpIfNot(s1, s2);
        if (comparisonDumpIfNotEqual != null) {
            throw new AssertionFailedError(comparisonDumpIfNotEqual);
        }
    }

    public void verifyEquals(String[] s1, String[] s2) {
        String comparisonDumpIfNotEqual = SeleneseTestCase.verifyEqualsAndReturnComparisonDumpIfNot(s1, s2);
        if (comparisonDumpIfNotEqual != null) {
            this.verificationErrors.append(comparisonDumpIfNotEqual);
        }
    }

    private static String verifyEqualsAndReturnComparisonDumpIfNot(String[] s1, String[] s2) {
        boolean misMatch = false;
        if (s1.length != s2.length) {
            misMatch = true;
        }
        for (int j = 0; j < s1.length; ++j) {
            if (SeleneseTestCase.seleniumEquals(s1[j], s2[j])) continue;
            misMatch = true;
            break;
        }
        if (misMatch) {
            return "Expected " + SeleneseTestCase.stringArrayToString(s1) + " but saw " + SeleneseTestCase.stringArrayToString(s2);
        }
        return null;
    }

    private static String stringArrayToString(String[] sa) {
        StringBuffer sb = new StringBuffer("{");
        for (int j = 0; j < sa.length; ++j) {
            sb.append(" ").append("\"").append(sa[j]).append("\"");
        }
        sb.append(" }");
        return sb.toString();
    }

    private static String stringArrayToSimpleString(String[] sa) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < sa.length; ++j) {
            sb.append(sa[j]);
            if (j >= sa.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public void verifyNotEquals(Object s1, Object s2) {
        try {
            SeleneseTestCase.assertNotEquals(s1, s2);
        }
        catch (AssertionFailedError e) {
            this.verificationErrors.append((Object)e);
        }
    }

    public void verifyNotEquals(boolean s1, boolean s2) {
        try {
            SeleneseTestCase.assertNotEquals(new Boolean(s1), new Boolean(s2));
        }
        catch (AssertionFailedError e) {
            this.verificationErrors.append((Object)e);
        }
    }

    public static void assertNotEquals(Object obj1, Object obj2) {
        if (obj1.equals(obj2)) {
            SeleneseTestCase.fail((String)("did not expect values to be equal (" + obj1.toString() + ")"));
        }
    }

    public static void assertNotEquals(boolean b1, boolean b2) {
        SeleneseTestCase.assertNotEquals(new Boolean(b1), new Boolean(b2));
    }

    public void pause(int millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkForVerificationErrors() {
        SeleneseTestCase.assertEquals("", this.verificationErrors.toString());
        this.clearVerificationErrors();
    }

    public void clearVerificationErrors() {
        this.verificationErrors = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.checkForVerificationErrors();
        }
        finally {
            this.selenium.stop();
        }
    }
}

