/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.SeleniumServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameGroupCommandQueueSet {
    private String currentLocalFrameAddress;
    private String currentSeleniumWindowName;
    private FrameAddress currentFrameAddress = null;
    private Map<FrameAddress, CommandQueue> frameAddressToCommandQueue = new ConcurrentHashMap<FrameAddress, CommandQueue>();
    public static final Map<String, FrameGroupCommandQueueSet> queueSets = new HashMap<String, FrameGroupCommandQueueSet>();
    private Map<FrameAddress, Boolean> frameAddressToJustLoaded = new HashMap<FrameAddress, Boolean>();
    private static Lock dataLock = new ReentrantLock();
    private static Condition resultArrivedOnAnyQueue = dataLock.newCondition();
    private final String sessionId;
    private Set<CommandQueue> orphanedQueues = new HashSet<CommandQueue>();
    public static final String DEFAULT_LOCAL_FRAME_ADDRESS = "top";
    public static final String DEFAULT_SELENIUM_WINDOW_NAME = "";

    public FrameGroupCommandQueueSet(String sessionId) {
        this.sessionId = sessionId;
        this.setCurrentFrameAddress(FrameAddress.make(DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_LOCAL_FRAME_ADDRESS));
    }

    private String selectWindow(String seleniumWindowName) {
        FrameAddress match;
        if (!SeleniumServer.isProxyInjectionMode()) {
            return this.doCommand("selectWindow", seleniumWindowName, DEFAULT_SELENIUM_WINDOW_NAME);
        }
        if ("null".equals(seleniumWindowName)) {
            this.currentSeleniumWindowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        if ((match = this.findMatchingFrameAddress(this.frameAddressToCommandQueue.keySet(), seleniumWindowName, DEFAULT_LOCAL_FRAME_ADDRESS)) == null) {
            return "ERROR: could not find window " + seleniumWindowName;
        }
        this.setCurrentFrameAddress(match);
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandQueue getCommandQueue() {
        dataLock.lock();
        try {
            CommandQueue commandQueue = this.getCommandQueue(this.currentFrameAddress);
            return commandQueue;
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameGroupCommandQueueSet getQueueSet(String sessionId) {
        dataLock.lock();
        try {
            FrameGroupCommandQueueSet queueSet = queueSets.get(sessionId);
            if (queueSet == null) {
                throw new RuntimeException("sessionId " + sessionId + " doesn't exist");
            }
            FrameGroupCommandQueueSet frameGroupCommandQueueSet = queueSet;
            return frameGroupCommandQueueSet;
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameGroupCommandQueueSet makeQueueSet(String sessionId) {
        dataLock.lock();
        try {
            FrameGroupCommandQueueSet queueSet = queueSets.get(sessionId);
            if (queueSet != null) {
                throw new RuntimeException("sessionId " + sessionId + " already exists");
            }
            queueSet = new FrameGroupCommandQueueSet(sessionId);
            queueSets.put(sessionId, queueSet);
            FrameGroupCommandQueueSet frameGroupCommandQueueSet = queueSet;
            return frameGroupCommandQueueSet;
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearQueueSet(String sessionId) {
        dataLock.lock();
        try {
            FrameGroupCommandQueueSet queue = queueSets.get(sessionId);
            queue.endOfLife();
            queueSets.remove(sessionId);
        }
        finally {
            dataLock.unlock();
        }
    }

    private CommandQueue getCommandQueue(FrameAddress frameAddress) {
        CommandQueue q = this.frameAddressToCommandQueue.get(frameAddress);
        if (q == null) {
            if (SeleniumServer.isDebugMode()) {
                SeleniumServer.log("---------allocating new CommandQueue for " + frameAddress);
            }
            q = new CommandQueue(this.sessionId, frameAddress, dataLock);
            this.frameAddressToCommandQueue.put(frameAddress, q);
        } else if (SeleniumServer.isDebugMode()) {
            SeleniumServer.log("---------retrieving CommandQueue for " + frameAddress);
        }
        return this.frameAddressToCommandQueue.get(frameAddress);
    }

    private void selectFrame(String localFrameAddress) {
        this.setCurrentLocalFrameAddress(localFrameAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doCommand(String command, String arg, String value) {
        dataLock.lock();
        try {
            if (SeleniumServer.isProxyInjectionMode()) {
                if (command.equals("close")) {
                    this.getCommandQueue().doCommandWithoutWaitingForAResponse(command, arg, value);
                    String string = "OK";
                    return string;
                }
                if (command.equals("selectFrame")) {
                    Object i$;
                    if (DEFAULT_SELENIUM_WINDOW_NAME.equals(arg)) {
                        this.selectFrame(DEFAULT_LOCAL_FRAME_ADDRESS);
                        String string = "OK";
                        return string;
                    }
                    boolean newFrameFound = false;
                    for (FrameAddress frameAddress : this.frameAddressToCommandQueue.keySet()) {
                        CommandQueue frameQ;
                        if (!frameAddress.getWindowName().equals(this.currentSeleniumWindowName) || !(frameQ = this.frameAddressToCommandQueue.get(frameAddress)).matchesFrameAddress(this.currentLocalFrameAddress, arg)) continue;
                        this.setCurrentFrameAddress(frameAddress);
                        newFrameFound = true;
                        break;
                    }
                    if (!newFrameFound) {
                        i$ = "ERROR: starting from frame " + this.currentFrameAddress + ", could not find frame " + arg;
                        return i$;
                    }
                    i$ = "OK";
                    return i$;
                }
                if (command.equals("selectWindow")) {
                    String newFrameFound = this.selectWindow(arg);
                    return newFrameFound;
                }
                if (command.equals("waitForPopUp")) {
                    String waitingForThisWindowName = arg;
                    int timeoutInSeconds = Integer.parseInt(value);
                    String result = this.waitForLoad(waitingForThisWindowName, DEFAULT_LOCAL_FRAME_ADDRESS, timeoutInSeconds);
                    if (!result.equals("OK")) {
                        String string = result;
                        return string;
                    }
                    String string = this.selectWindow(waitingForThisWindowName);
                    return string;
                }
                if (command.equals("waitForPageToLoad")) {
                    String waitingForThisWindowName = this.waitForLoad(arg);
                    return waitingForThisWindowName;
                }
                if (command.equals("open")) {
                    String t = this.getCommandQueue().doCommand(command, arg, value);
                    if (!"OK".equals(t)) {
                        String string = t;
                        return string;
                    }
                    String string = this.waitForLoad((long)SeleniumServer.getTimeoutInSeconds() * 1000L);
                    return string;
                }
                if (command.endsWith("AndWait")) {
                    command = command.substring(0, command.length() - "AndWait".length());
                    String t = this.getCommandQueue().doCommand(command, arg, value);
                    if (!t.startsWith("OK")) {
                        String string = t;
                        return string;
                    }
                    String string = this.waitForLoad((long)SeleniumServer.getTimeoutInSeconds() * 1000L);
                    return string;
                }
            }
            String string = this.getCommandQueue().doCommand(command, arg, value);
            return string;
        }
        finally {
            dataLock.unlock();
        }
    }

    private String waitForLoad(long timeoutInMilliseconds) {
        int timeoutInSeconds = (int)(timeoutInMilliseconds / 1000L);
        if (timeoutInSeconds == 0) {
            timeoutInSeconds = 1;
        }
        return this.waitForLoad(this.currentSeleniumWindowName, this.currentLocalFrameAddress, timeoutInSeconds);
    }

    private String waitForLoad(String timeoutInMilliseconds) {
        return this.waitForLoad(Long.parseLong(timeoutInMilliseconds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitForLoad(String waitingForThisWindowName, String waitingForThisLocalFrame, int timeoutInSeconds) {
        dataLock.lock();
        try {
            FrameAddress matchingFrameAddress = null;
            while (timeoutInSeconds >= 0) {
                matchingFrameAddress = this.findMatchingFrameAddress(this.frameAddressToJustLoaded.keySet(), waitingForThisWindowName, waitingForThisLocalFrame);
                if (matchingFrameAddress != null) {
                    SeleniumServer.log("wait is over: window \"" + waitingForThisWindowName + "\" was seen at last (" + matchingFrameAddress + ")");
                    this.frameAddressToJustLoaded.remove(matchingFrameAddress);
                    String string = "OK";
                    return string;
                }
                SeleniumServer.log("waiting for window \"" + waitingForThisWindowName + "\"" + " local frame \"" + waitingForThisLocalFrame + "\"");
                try {
                    resultArrivedOnAnyQueue.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                --timeoutInSeconds;
            }
            String string = "ERROR: timed out waiting for window \"" + waitingForThisWindowName + "\" to appear";
            return string;
        }
        finally {
            dataLock.unlock();
        }
    }

    private FrameAddress findMatchingFrameAddress(Set<FrameAddress> frameAddresses, String windowName, String localFrame) {
        for (FrameAddress frameAddress : frameAddresses) {
            if (!this.matchesFrameAddress(frameAddress, windowName, localFrame)) continue;
            return frameAddress;
        }
        return null;
    }

    private boolean matchesFrameAddress(FrameAddress f, String windowName, String localFrame) {
        if (windowName == null || windowName.equals("null")) {
            windowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        if (!f.getLocalFrameAddress().equals(localFrame)) {
            return false;
        }
        if (f.getWindowName().equals(windowName)) {
            return true;
        }
        return this.frameAddressToCommandQueue.get(f).isWindowPointedToByJsVariable(windowName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCommand handleCommandResult(String commandResult, FrameAddress incomingFrameAddress, String uniqueId, boolean justLoaded, List jsWindowNameVars) {
        dataLock.lock();
        try {
            this.markWhetherJustLoaded(incomingFrameAddress, justLoaded);
            CommandQueue queue = !SeleniumServer.isProxyInjectionMode() ? this.getCommandQueue() : this.getCommandQueue(incomingFrameAddress);
            queue.setUniqueId(uniqueId);
            if (jsWindowNameVars != null) {
                for (Object jsWindowNameVar : jsWindowNameVars) {
                    queue.addJsWindowNameVar((String)jsWindowNameVar);
                }
            }
            RemoteCommand remoteCommand = queue.handleCommandResult(commandResult);
            return remoteCommand;
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOfLife() {
        dataLock.lock();
        try {
            for (CommandQueue frameQ : this.frameAddressToCommandQueue.values()) {
                frameQ.endOfLife();
            }
        }
        finally {
            dataLock.unlock();
        }
    }

    private boolean justLoaded(FrameAddress frameAddress) {
        return this.frameAddressToJustLoaded.containsKey(frameAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markWhetherJustLoaded(FrameAddress frameAddress, boolean justLoaded) {
        boolean oldState = this.justLoaded(frameAddress);
        if (oldState != justLoaded) {
            dataLock.lock();
            try {
                if (justLoaded) {
                    if (SeleniumServer.isDebugMode()) {
                        SeleniumServer.log(frameAddress + " marked as just loaded");
                    }
                    this.frameAddressToJustLoaded.put(frameAddress, true);
                } else {
                    if (SeleniumServer.isDebugMode()) {
                        SeleniumServer.log(frameAddress + " marked as NOT just loaded");
                    }
                    this.frameAddressToJustLoaded.remove(frameAddress);
                }
                resultArrivedOnAnyQueue.signalAll();
            }
            finally {
                dataLock.unlock();
            }
        }
    }

    private void setCurrentLocalFrameAddress(String localFrameAddress) {
        this.setCurrentFrameAddress(FrameAddress.make(this.currentSeleniumWindowName, localFrameAddress));
    }

    private void setCurrentFrameAddress(FrameAddress frameAddress) {
        assert (frameAddress != null);
        this.currentFrameAddress = frameAddress;
        this.currentSeleniumWindowName = frameAddress.getWindowName();
        this.currentLocalFrameAddress = frameAddress.getLocalFrameAddress();
        if (SeleniumServer.isDebugMode()) {
            SeleniumServer.log("Current frame address set to " + this.currentFrameAddress + ".");
        }
    }

    public static FrameAddress makeFrameAddress(String seleniumWindowName, String localFrameAddress) {
        if (seleniumWindowName == null) {
            seleniumWindowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        return FrameAddress.make(seleniumWindowName, localFrameAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        dataLock.lock();
        try {
            if (SeleniumServer.isProxyInjectionMode()) {
                LinkedList<FrameAddress> newOrphans = new LinkedList<FrameAddress>();
                for (FrameAddress frameAddress : this.frameAddressToCommandQueue.keySet()) {
                    if (frameAddress.getLocalFrameAddress().equals(DEFAULT_LOCAL_FRAME_ADDRESS) && frameAddress.getWindowName().equals(DEFAULT_SELENIUM_WINDOW_NAME)) continue;
                    this.selectWindow(frameAddress.getWindowName());
                    this.selectFrame(frameAddress.getLocalFrameAddress());
                    CommandQueue q = this.getCommandQueue();
                    if (frameAddress.getLocalFrameAddress().equals(DEFAULT_LOCAL_FRAME_ADDRESS)) {
                        if (SeleniumServer.isDebugMode()) {
                            SeleniumServer.log("Trying to close " + frameAddress);
                        }
                        q.doCommandWithoutWaitingForAResponse("getEval", "selenium.browserbot.getCurrentWindow().close()", DEFAULT_SELENIUM_WINDOW_NAME);
                    }
                    this.orphanedQueues.add(q);
                    newOrphans.add(frameAddress);
                }
                for (FrameAddress frameAddress : newOrphans) {
                    this.frameAddressToCommandQueue.remove(frameAddress);
                }
            }
            this.selectWindow(DEFAULT_SELENIUM_WINDOW_NAME);
            String defaultUrl = "http://localhost:" + SeleniumServer.getPortDriversShouldContact() + "/selenium-server/core/InjectedRemoteRunner.html";
            this.doCommand("open", defaultUrl, DEFAULT_SELENIUM_WINDOW_NAME);
        }
        finally {
            dataLock.unlock();
        }
    }
}

