/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.HttpTunnel;
import org.mortbay.http.SslListener;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.ModifiedIO;
import org.openqa.selenium.server.SeleniumServer;

public class ProxyHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(ProxyHandler.class);
    protected Set<String> _proxyHostsWhiteList;
    protected Set<String> _proxyHostsBlackList;
    protected int _tunnelTimeoutMs = 250;
    private boolean _anonymous = false;
    private transient boolean _chained = false;
    private final Map<String, SslRelay> _sslMap = new LinkedHashMap<String, SslRelay>();
    protected StringMap _DontProxyHeaders = new StringMap();
    protected StringMap _ProxyAuthHeaders;
    protected StringMap _ProxySchemes;
    protected HashSet<Integer> _allowedConnectPorts;

    public ProxyHandler() {
        Object o = new Object();
        this._DontProxyHeaders.setIgnoreCase(true);
        this._DontProxyHeaders.put("Proxy-Connection", o);
        this._DontProxyHeaders.put("Connection", o);
        this._DontProxyHeaders.put("keep-alive", o);
        this._DontProxyHeaders.put("Transfer-Encoding", o);
        this._DontProxyHeaders.put("TE", o);
        this._DontProxyHeaders.put("Trailer", o);
        this._DontProxyHeaders.put("Upgrade", o);
        this._ProxyAuthHeaders = new StringMap();
        o = new Object();
        this._ProxyAuthHeaders.put("Proxy-Authorization", o);
        this._ProxyAuthHeaders.put("Proxy-Authenticate", o);
        this._ProxySchemes = new StringMap();
        o = new Object();
        this._ProxySchemes.setIgnoreCase(true);
        this._ProxySchemes.put("http", o);
        this._ProxySchemes.put("https", o);
        this._ProxySchemes.put("ftp", o);
        this._allowedConnectPorts = new HashSet();
        this._allowedConnectPorts.add(80);
        this._allowedConnectPorts.add(SeleniumServer.getDefaultPort());
        this._allowedConnectPorts.add(8000);
        this._allowedConnectPorts.add(8080);
        this._allowedConnectPorts.add(8888);
        this._allowedConnectPorts.add(443);
        this._allowedConnectPorts.add(8443);
    }

    public void start() throws Exception {
        this._chained = System.getProperty("http.proxyHost") != null || SeleniumServer.isForceProxyChain();
        super.start();
    }

    public String[] getProxyHostsWhiteList() {
        if (this._proxyHostsWhiteList == null || this._proxyHostsWhiteList.size() == 0) {
            return new String[0];
        }
        String[] hosts = new String[this._proxyHostsWhiteList.size()];
        hosts = this._proxyHostsWhiteList.toArray(hosts);
        return hosts;
    }

    public void setProxyHostsWhiteList(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            this._proxyHostsWhiteList = null;
        } else {
            this._proxyHostsWhiteList = new HashSet<String>();
            for (int i = 0; i < hosts.length; ++i) {
                String host = hosts[i];
                if (host == null || host.trim().length() <= 0) continue;
                this._proxyHostsWhiteList.add(host);
            }
        }
    }

    public String[] getProxyHostsBlackList() {
        if (this._proxyHostsBlackList == null || this._proxyHostsBlackList.size() == 0) {
            return new String[0];
        }
        String[] hosts = new String[this._proxyHostsBlackList.size()];
        hosts = this._proxyHostsBlackList.toArray(hosts);
        return hosts;
    }

    public void setProxyHostsBlackList(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            this._proxyHostsBlackList = null;
        } else {
            this._proxyHostsBlackList = new HashSet<String>();
            for (int i = 0; i < hosts.length; ++i) {
                String host = hosts[i];
                if (host == null || host.trim().length() <= 0) continue;
                this._proxyHostsBlackList.add(host);
            }
        }
    }

    public int getTunnelTimeoutMs() {
        return this._tunnelTimeoutMs;
    }

    public void setTunnelTimeoutMs(int ms) {
        this._tunnelTimeoutMs = ms;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block6: {
            URI uri = request.getURI();
            if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
                response.setField("Connection", "close");
                this.handleConnect(pathInContext, pathParams, request, response);
                return;
            }
            try {
                URL url = this.isProxied(uri);
                if (url == null) {
                    if (this.isForbidden(uri)) {
                        this.sendForbid(request, response, uri);
                    }
                    return;
                }
                if (this.isSeleniumUrl(url.toString())) {
                    request.setHandled(false);
                    return;
                }
                this.proxyPlainTextRequest(url, pathInContext, pathParams, request, response);
            }
            catch (Exception e) {
                log.warn((Object)("Could not proxy " + uri), (Throwable)e);
                LogSupport.ignore((Log)log, (Throwable)e);
                if (response.isCommitted()) break block6;
                response.sendError(400);
            }
        }
    }

    private boolean isSeleniumUrl(String url) {
        int slashSlash = url.indexOf("//");
        if (slashSlash == -1) {
            return false;
        }
        int nextSlash = url.indexOf("/", slashSlash + 2);
        if (nextSlash == -1) {
            return false;
        }
        int seleniumServer = url.indexOf("/selenium-server/");
        if (seleniumServer == -1) {
            return false;
        }
        return seleniumServer == nextSlash;
    }

    protected long proxyPlainTextRequest(URL url, String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws IOException {
        String cache_control;
        String connectionHdr;
        if (log.isDebugEnabled()) {
            log.debug((Object)("PROXY URL=" + url));
        }
        URLConnection connection = url.openConnection();
        connection.setAllowUserInteraction(false);
        if (SeleniumServer.isProxyInjectionMode()) {
            this.adjustRequestForProxyInjection(request, connection);
        }
        HttpURLConnection http = null;
        if (connection instanceof HttpURLConnection) {
            http = (HttpURLConnection)connection;
            http.setRequestMethod(request.getMethod());
            http.setInstanceFollowRedirects(false);
        }
        if ((connectionHdr = request.getField("Connection")) != null && (connectionHdr.equalsIgnoreCase("keep-alive") || connectionHdr.equalsIgnoreCase("close"))) {
            connectionHdr = null;
        }
        boolean xForwardedFor = false;
        boolean hasContent = false;
        Enumeration enm = request.getFieldNames();
        while (enm.hasMoreElements()) {
            String hdr = (String)enm.nextElement();
            if (this._DontProxyHeaders.containsKey((Object)hdr) || !this._chained && this._ProxyAuthHeaders.containsKey((Object)hdr) || connectionHdr != null && connectionHdr.indexOf(hdr) >= 0) continue;
            if ("Content-Type".equals(hdr)) {
                hasContent = true;
            }
            Enumeration vals = request.getFieldValues(hdr);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (val == null || "Referer".equals(hdr) && -1 != val.indexOf("/selenium-server/")) continue;
                connection.addRequestProperty(hdr, val);
                xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
            }
        }
        if (!this._anonymous) {
            connection.setRequestProperty("Via", "1.1 (jetty)");
        }
        if (!xForwardedFor) {
            connection.addRequestProperty("X-Forwarded-For", request.getRemoteAddr());
        }
        if ((cache_control = request.getField("Cache-Control")) != null && (cache_control.indexOf("no-cache") >= 0 || cache_control.indexOf("no-store") >= 0)) {
            connection.setUseCaches(false);
        }
        this.customizeConnection(pathInContext, pathParams, request, connection);
        try {
            connection.setDoInput(true);
            InputStream in = request.getInputStream();
            if (hasContent) {
                connection.setDoOutput(true);
                IO.copy((InputStream)in, (OutputStream)connection.getOutputStream());
            }
            connection.connect();
        }
        catch (Exception e) {
            LogSupport.ignore((Log)log, (Throwable)e);
        }
        InputStream proxy_in = null;
        if (http != null) {
            proxy_in = http.getErrorStream();
            int code = http.getResponseCode();
            response.setStatus(code);
            response.setReason(http.getResponseMessage());
            String contentType = http.getContentType();
            if (SeleniumServer.isDebugMode()) {
                SeleniumServer.log("Content-Type is: " + contentType);
            }
        }
        if (proxy_in == null) {
            try {
                proxy_in = connection.getInputStream();
            }
            catch (Exception e) {
                LogSupport.ignore((Log)log, (Throwable)e);
                proxy_in = http.getErrorStream();
            }
        }
        response.removeField("Date");
        response.removeField("Server");
        int h = 0;
        String hdr = connection.getHeaderFieldKey(h);
        String val = connection.getHeaderField(h);
        while (hdr != null || val != null) {
            if (!(hdr == null || val == null || this._DontProxyHeaders.containsKey((Object)hdr) || !this._chained && this._ProxyAuthHeaders.containsKey((Object)hdr))) {
                response.addField(hdr, val);
            }
            hdr = connection.getHeaderFieldKey(++h);
            val = connection.getHeaderField(h);
        }
        if (!this._anonymous) {
            response.setField("Via", "1.1 (jetty)");
        }
        response.removeField("ETag");
        response.removeField("Last-Modified");
        long bytesCopied = -1L;
        request.setHandled(true);
        if (proxy_in != null) {
            boolean injectableResponse;
            boolean bl = injectableResponse = http.getResponseCode() == 200 || http.getResponseCode() >= 400 && http.getResponseCode() < 600;
            bytesCopied = SeleniumServer.isProxyInjectionMode() && injectableResponse ? (SeleniumServer.shouldInject(request.getPath()) ? InjectionHelper.injectJavaScript(request, response, proxy_in, response.getOutputStream()) : ModifiedIO.copy(proxy_in, response.getOutputStream())) : ModifiedIO.copy(proxy_in, response.getOutputStream());
        }
        return bytesCopied;
    }

    private void adjustRequestForProxyInjection(HttpRequest request, URLConnection connection) {
        request.setState(0);
        if (request.containsField("If-Modified-Since")) {
            request.removeField("If-Modified-Since");
            request.removeField("If-None-Match");
            connection.setUseCaches(false);
        }
        request.removeField("Accept-Encoding");
        request.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnect(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block16: {
            URI uri = request.getURI();
            try {
                HttpTunnel tunnel;
                SslRelay listener;
                InetAddrPort addrPort;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CONNECT: " + uri));
                }
                if (this.isForbidden("https", (addrPort = new InetAddrPort(uri.toString())).getHost(), addrPort.getPort(), false)) {
                    this.sendForbid(request, response, uri);
                    break block16;
                }
                HttpConnection http_connection = request.getHttpConnection();
                http_connection.forceClose();
                HttpServer server = http_connection.getHttpServer();
                Map<String, SslRelay> map = this._sslMap;
                synchronized (map) {
                    listener = this._sslMap.get(uri.toString());
                    if (listener == null) {
                        int length;
                        listener = new SslRelay(addrPort);
                        File keystore = File.createTempFile("selenium-rc-" + addrPort.getHost() + "-" + addrPort.getPort(), "keystore");
                        String urlString = "http://dangerous-certificate-authority.openqa.org/genkey.jsp?padding=" + this._sslMap.size();
                        ArrayList<InetAddrPort> addresses = new ArrayList<InetAddrPort>();
                        addresses.add(addrPort);
                        for (InetAddrPort addr : addresses) {
                            urlString = urlString + "&domain=" + addr.getHost();
                        }
                        URL url = new URL(urlString);
                        URLConnection conn = url.openConnection();
                        conn.connect();
                        InputStream is = conn.getInputStream();
                        byte[] buffer = new byte[1024];
                        FileOutputStream fos = new FileOutputStream(keystore);
                        while ((length = is.read(buffer)) != -1) {
                            fos.write(buffer, 0, length);
                        }
                        fos.close();
                        is.close();
                        listener.setKeystore(keystore.getAbsolutePath());
                        listener.setPassword("password");
                        listener.setKeyPassword("password");
                        server.addListener((HttpListener)listener);
                        try {
                            listener.start();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw e;
                        }
                        this._sslMap.put(uri.toString(), listener);
                    }
                }
                int port = listener.getPort();
                int timeoutMs = 30000;
                Object maybesocket = http_connection.getConnection();
                if (maybesocket instanceof Socket) {
                    Socket s = (Socket)maybesocket;
                    timeoutMs = s.getSoTimeout();
                }
                if ((tunnel = this.newHttpTunnel(request, response, InetAddress.getLocalHost(), port, timeoutMs)) != null) {
                    if (this._tunnelTimeoutMs > 0) {
                        tunnel.getSocket().setSoTimeout(this._tunnelTimeoutMs);
                        if (maybesocket instanceof Socket) {
                            Socket s = (Socket)maybesocket;
                            s.setSoTimeout(this._tunnelTimeoutMs);
                        }
                    }
                    tunnel.setTimeoutMs(timeoutMs);
                    this.customizeConnection(pathInContext, pathParams, request, tunnel.getSocket());
                    request.getHttpConnection().setHttpTunnel(tunnel);
                    response.setStatus(200);
                    response.setContentLength(0);
                }
                request.setHandled(true);
            }
            catch (Exception e) {
                System.err.println("handleConnect: ProxyHandler.java: " + e);
                LogSupport.ignore((Log)log, (Throwable)e);
                response.sendError(500);
            }
        }
    }

    protected HttpTunnel newHttpTunnel(HttpRequest request, HttpResponse response, InetAddress iaddr, int port, int timeoutMS) throws IOException {
        try {
            Socket socket = null;
            LineInput in = null;
            String chained_proxy_host = System.getProperty("http.proxyHost");
            if (chained_proxy_host == null) {
                socket = new Socket(iaddr, port);
                socket.setSoTimeout(timeoutMS);
                socket.setTcpNoDelay(true);
            } else {
                int space1;
                int chained_proxy_port = Integer.getInteger("http.proxyPort", 8888);
                Socket chain_socket = new Socket(chained_proxy_host, chained_proxy_port);
                chain_socket.setSoTimeout(timeoutMS);
                chain_socket.setTcpNoDelay(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("chain proxy socket=" + chain_socket));
                }
                LineInput line_in = new LineInput(chain_socket.getInputStream());
                byte[] connect = request.toString().getBytes(StringUtil.__ISO_8859_1);
                chain_socket.getOutputStream().write(connect);
                String chain_response_line = line_in.readLine();
                HttpFields chain_response = new HttpFields();
                chain_response.read(line_in);
                int space0 = chain_response_line.indexOf(32);
                if (space0 > 0 && space0 + 1 < chain_response_line.length() && (space1 = chain_response_line.indexOf(32, space0 + 1)) > space0) {
                    int code = Integer.parseInt(chain_response_line.substring(space0 + 1, space1));
                    if (code >= 200 && code < 300) {
                        socket = chain_socket;
                        in = line_in;
                    } else {
                        Enumeration iter = chain_response.getFieldNames();
                        while (iter.hasMoreElements()) {
                            String name = (String)iter.nextElement();
                            if (this._DontProxyHeaders.containsKey((Object)name)) continue;
                            Enumeration values = chain_response.getValues(name);
                            while (values.hasMoreElements()) {
                                String value = (String)values.nextElement();
                                response.setField(name, value);
                            }
                        }
                        response.sendError(code);
                        if (!chain_socket.isClosed()) {
                            chain_socket.close();
                        }
                    }
                }
            }
            if (socket == null) {
                return null;
            }
            return new HttpTunnel(socket, in, null);
        }
        catch (IOException e) {
            log.debug((Object)e);
            response.sendError(400);
            return null;
        }
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, Socket socket) {
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, URLConnection connection) {
    }

    protected URL isProxied(URI uri) throws MalformedURLException {
        if (this.isForbidden(uri)) {
            return null;
        }
        return new URL(uri.toString());
    }

    protected boolean isForbidden(URI uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        return this.isForbidden(scheme, host, port, true);
    }

    protected boolean isForbidden(String scheme, String host, int port, boolean openNonPrivPorts) {
        if (!(port <= 0 || this._allowedConnectPorts.contains(new Integer(port)) || openNonPrivPorts && port > 1024)) {
            return true;
        }
        if (scheme == null || !this._ProxySchemes.containsKey((Object)scheme)) {
            return true;
        }
        if (this._proxyHostsWhiteList != null && !this._proxyHostsWhiteList.contains(host)) {
            return true;
        }
        return this._proxyHostsBlackList != null && this._proxyHostsBlackList.contains(host);
    }

    protected void sendForbid(HttpRequest request, HttpResponse response, URI uri) throws IOException {
        response.sendError(403, "Forbidden for Proxy");
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this._anonymous = anonymous;
    }

    private static class SslRelay
    extends SslListener {
        InetAddrPort _addr;

        SslRelay(InetAddrPort addr) {
            this._addr = addr;
        }

        protected void customizeRequest(Socket socket, HttpRequest request) {
            super.customizeRequest(socket, request);
            URI uri = request.getURI();
            uri.setScheme("https");
            uri.setHost(this._addr.getHost());
            uri.setPort(this._addr.getPort());
        }
    }
}

