/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.util.IO;
import org.openqa.selenium.server.ClassPathResource;
import org.openqa.selenium.server.HtmlIdentifier;
import org.openqa.selenium.server.ModifiedIO;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.SeleniumServer;

public class InjectionHelper {
    private static HashMap<String, HashMap<String, String>> jsStateInitializersBySessionId = new HashMap();
    private static HashMap<String, String> sessionIdToUniqueId = new HashMap();
    private static HashMap<String, String> contentTransformations = new HashMap();
    private static List<String> userJsInjectionFiles = new LinkedList<String>();

    public static void saveJsStateInitializer(String sessionId, String uniqueId, String jsVarName, String jsStateInitializer) {
        if (sessionIdToUniqueId.containsKey(sessionId) && !sessionIdToUniqueId.get(sessionId).equals(uniqueId)) {
            jsStateInitializersBySessionId.remove(sessionId);
            sessionIdToUniqueId.put(sessionId, uniqueId);
        }
        if (SeleniumServer.isDebugMode()) {
            SeleniumServer.log("Saving JavaScript state for session " + sessionId + "/" + uniqueId + " " + jsVarName + ": " + jsStateInitializer);
        }
        if (!jsStateInitializersBySessionId.containsKey(sessionId)) {
            jsStateInitializersBySessionId.put(sessionId, new HashMap());
        }
        HashMap<String, String> h = jsStateInitializersBySessionId.get(sessionId);
        StringBuffer sb = new StringBuffer("if (uniqueId!='");
        sb.append(uniqueId).append("') {").append(jsStateInitializer).append("}");
        h.put(jsVarName, sb.toString());
    }

    public static String restoreJsStateInitializer(String sessionId, String uniqueId) {
        if (!jsStateInitializersBySessionId.containsKey(sessionId)) {
            return "";
        }
        HashMap<String, String> h = jsStateInitializersBySessionId.get(sessionId);
        if (h.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String jsVarName : h.keySet()) {
            String jsStateInitializer = h.get(jsVarName);
            sb.append(jsStateInitializer).append('\n');
            if (!SeleniumServer.isDebugMode()) continue;
            SeleniumServer.log("Restoring JavaScript state for session " + sessionId + "/" + uniqueId + ": key=" + jsVarName + ": " + jsStateInitializer);
        }
        return sb.toString();
    }

    public static void init() {
        String key = "__SELENIUM_JS__";
        StringBuffer sb = new StringBuffer();
        try {
            InjectionHelper.appendFileContent(sb, "/jsunit/app/jsUnitCore.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/xmlextras.js");
            InjectionHelper.appendFileContent(sb, "/core/lib/cssQuery/cssQuery-p.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/htmlutils.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-browserdetect.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-browserbot.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/find_matching_child.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-api.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-commandhandlers.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-executionloop.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-remoterunner.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-logging.js");
            InjectionHelper.appendFileContent(sb, "/core/xpath/misc.js");
            InjectionHelper.appendFileContent(sb, "/core/xpath/dom.js");
            InjectionHelper.appendFileContent(sb, "/core/xpath/xpath.js");
            InjectionHelper.appendFileContent(sb, "/core/scripts/user-extensions.js");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        contentTransformations.put(key, sb.toString());
    }

    private static void appendFileContent(StringBuffer sb, String url) throws IOException {
        InputStream in = new ClassPathResource(url).getInputStream();
        if (in == null) {
            if (!url.endsWith("user-extensions.js")) {
                throw new RuntimeException("couldn't find " + url);
            }
        } else {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf, 0, 8192)) != -1) {
                sb.append(new String(buf, 0, len));
            }
        }
    }

    public static long injectJavaScript(HttpRequest request, HttpResponse response, InputStream in, OutputStream out) throws IOException {
        if (!contentTransformations.containsKey("__SELENIUM_JS__")) {
            InjectionHelper.init();
        }
        int len = 102400;
        byte[] buf = new byte[len];
        if ((len = InjectionHelper.readStream(in, buf, len)) == -1) {
            return -1L;
        }
        int lengthOfBOM = InjectionHelper.getBOMLength(buf);
        String data = new String(buf, lengthOfBOM, len);
        boolean isKnownToBeHtml = HtmlIdentifier.shouldBeInjected(request.getPath(), response.getContentType(), data);
        String url = response.getHttpRequest().getRequestURL().toString();
        if (SeleniumServer.getDebugURL().equals(url)) {
            System.out.println("debug URL seen");
        }
        if (!isKnownToBeHtml) {
            out.write(buf, 0, len);
        }
        String sessionId = SeleniumDriverResourceHandler.getLastSessionId();
        long bytesCopied = len;
        if (SeleniumServer.isDebugMode()) {
            SeleniumServer.log(url + " (InjectionHelper looking)");
        }
        if (!isKnownToBeHtml) {
            bytesCopied += ModifiedIO.copy(in, out);
        } else {
            if (SeleniumServer.isDebugMode()) {
                SeleniumServer.log("injecting...");
            }
            response.removeField("Content-Length");
            String injectionHtml = "/core/scripts/injection.html";
            InputStream jsIn = new ClassPathResource(injectionHtml).getInputStream();
            contentTransformations.put("@SESSION_ID@", sessionId);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InjectionHelper.writeDataWithUserTransformations("", jsIn, baos);
            jsIn.close();
            baos.write(InjectionHelper.setSomeJsVars(sessionId));
            for (String filename : userJsInjectionFiles) {
                jsIn = new FileInputStream(filename);
                IO.copy(jsIn, baos);
            }
            int headIndex = -1;
            data = headIndex != -1 ? data.substring(0, headIndex + 6) + baos.toString() + data.substring(headIndex + 6) : baos.toString() + data;
            bytesCopied += InjectionHelper.writeDataWithUserTransformations(data, in, out);
        }
        return bytesCopied;
    }

    private static int getBOMLength(byte[] buf) {
        if (buf != null && buf.length >= 3 && buf[0] == -17 && buf[1] == -69 && buf[2] == -65) {
            return 3;
        }
        return 0;
    }

    private static int readStream(InputStream in, byte[] buf, int bufLen) throws IOException {
        int bytesRead;
        int offset = 0;
        while ((bytesRead = in.read(buf, offset, bufLen - offset)) != -1 && (offset += bytesRead) < bufLen) {
        }
        int bytesReadTotal = offset;
        return bytesReadTotal;
    }

    private static long writeDataWithUserTransformations(String data, InputStream in, OutputStream out) throws IOException {
        long bytesWritten = 0L;
        byte[] buf = new byte[8192];
        while (true) {
            for (String beforeRegexp : contentTransformations.keySet()) {
                String after = contentTransformations.get(beforeRegexp);
                if (after == null) {
                    System.out.println("Warning: no transformation seen for key " + beforeRegexp);
                    continue;
                }
                try {
                    data = data.replaceAll(beforeRegexp, after);
                }
                catch (IllegalArgumentException e) {
                    data = data.replace(beforeRegexp, after);
                }
            }
            out.write(data.getBytes());
            int len = in.read(buf);
            if (len == -1) break;
            bytesWritten += (long)len;
            data = new String(buf, 0, len);
        }
        return bytesWritten;
    }

    private static byte[] setSomeJsVars(String sessionId) {
        StringBuffer moreJs = new StringBuffer();
        if (SeleniumServer.isDebugMode()) {
            moreJs.append("debugMode = true;\n");
        }
        moreJs.append("injectedSessionId = ").append(sessionId).append(";\n");
        return InjectionHelper.makeJsChunk(moreJs.toString());
    }

    private static byte[] makeJsChunk(String js) {
        StringBuffer sb = new StringBuffer("\n<script language=\"JavaScript\">\n");
        sb.append(js).append("\n</script>\n");
        return sb.toString().getBytes();
    }

    public static boolean addUserContentTransformation(String before, String after) {
        contentTransformations.put(before, after);
        return true;
    }

    public static boolean addUserJsInjectionFile(String fileName) {
        File f = new File(fileName);
        if (!f.canRead()) {
            System.out.println("Error: cannot read user JavaScript injection file " + fileName);
            return false;
        }
        userJsInjectionFiles.add(fileName);
        return true;
    }

    public static boolean userContentTransformationsExist() {
        return !contentTransformations.isEmpty();
    }

    public static boolean userJsInjectionsExist() {
        return !userJsInjectionFiles.isEmpty();
    }
}

