/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class FirefoxCustomProfileLauncher
extends AbstractBrowserLauncher {
    private static final String DEFAULT_NONWINDOWS_LOCATION = "/Applications/Firefox.app/Contents/MacOS/firefox-bin";
    private static boolean simple = false;
    private String[] cmdarray;
    private boolean closed = false;
    private String commandPath;
    private Process process;
    protected LauncherUtils.ProxySetting proxySetting = LauncherUtils.ProxySetting.PROXY_SELENIUM_TRAFFIC_ONLY;
    private static AsyncExecute exe = new AsyncExecute();
    private int port;
    private File customProfileDir;

    public FirefoxCustomProfileLauncher(int port, String sessionId) {
        this(port, sessionId, FirefoxCustomProfileLauncher.findBrowserLaunchLocation());
    }

    public FirefoxCustomProfileLauncher(int port, String sessionId, String browserLaunchLocation) {
        super(sessionId);
        this.init();
        this.commandPath = browserLaunchLocation;
        this.port = port;
        this.sessionId = sessionId;
        exe.setEnvironment(new String[]{"MOZ_NO_REMOTE=1"});
        if (!WindowsUtils.thisIsWindows()) {
            File execDirect;
            File firefoxBin = AsyncExecute.whichExec(this.commandPath);
            if (firefoxBin == null && (execDirect = new File(this.commandPath)).isAbsolute() && execDirect.exists()) {
                firefoxBin = execDirect;
            }
            if (firefoxBin != null) {
                LauncherUtils.assertNotScriptFile(firefoxBin);
                String libPathKey = FirefoxCustomProfileLauncher.getLibPathKey();
                String libPath = WindowsUtils.loadEnvironment().getProperty(libPathKey);
                exe.setEnvironment(new String[]{"MOZ_NO_REMOTE=1", libPathKey + "=" + libPath + ":" + firefoxBin.getParent()});
            }
        }
    }

    protected void init() {
    }

    private static String getLibPathKey() {
        if (WindowsUtils.thisIsWindows()) {
            return WindowsUtils.getExactPathEnvKey();
        }
        if (Os.isFamily("mac")) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    private static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("firefoxDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.thisIsWindows() ? WindowsUtils.getProgramFilesPath() + "\\Mozilla Firefox\\firefox.exe" : DEFAULT_NONWINDOWS_LOCATION;
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        if (WindowsUtils.thisIsWindows()) {
            File firefoxEXE = AsyncExecute.whichExec("firefox.exe");
            if (firefoxEXE != null) {
                return firefoxEXE.getAbsolutePath();
            }
            throw new RuntimeException("Firefox couldn't be found in the path!\nPlease add the directory containing firefox.exe to your PATH environment\nvariable, or explicitly specify a path to Firefox like this:\n*firefox c:\\blah\\firefox.exe");
        }
        File firefoxBin = AsyncExecute.whichExec("firefox-bin");
        if (firefoxBin != null) {
            return firefoxBin.getAbsolutePath();
        }
        throw new RuntimeException("Firefox couldn't be found in the path!\nPlease add the directory containing 'firefox-bin' to your PATH environment\nvariable, or explicitly specify a path to Firefox like this:\n*firefox /blah/blah/firefox-bin");
    }

    protected void launch(String url) {
        try {
            System.out.println("customProfileDir = " + this.customProfileDir());
            this.makeCustomProfile(this.customProfileDir());
            String chromeURL = "chrome://killff/content/kill.html";
            this.cmdarray = new String[]{this.commandPath, "-profile", this.customProfileDir().getAbsolutePath(), "-chrome", chromeURL};
            System.out.println("Preparing Firefox profile...");
            exe.setCommandline(this.cmdarray);
            exe.execute();
            this.waitForFullProfileToBeCreated(20000L);
            System.out.println("Launching Firefox...");
            this.cmdarray = new String[]{this.commandPath, "-profile", this.customProfileDir().getAbsolutePath(), url};
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void makeCustomProfile(File customProfileDirectory) throws IOException {
        if (simple) {
            return;
        }
        File firefoxProfileTemplate = SeleniumServer.getFirefoxProfileTemplate();
        if (firefoxProfileTemplate != null) {
            LauncherUtils.copyDirectory(firefoxProfileTemplate, this.customProfileDir);
        }
        ResourceExtractor.extractResourcePath(this.getClass(), "/customProfileDirCUSTFF", this.customProfileDir);
        LauncherUtils.generatePacAndPrefJs(customProfileDirectory, this.port, this.proxySetting, null);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.process == null) {
            return;
        }
        System.out.println("Killing Firefox...");
        Throwable taskKillException = null;
        FileLockRemainedException fileLockException = null;
        int exitValue = AsyncExecute.killProcess(this.process);
        if (exitValue == 0) {
            System.err.println("WARNING: Firefox seems to have ended on its own (did we kill the real browser???)");
        }
        try {
            this.waitForFileLockToGoAway(0L, 500L);
        }
        catch (FileLockRemainedException e1) {
            fileLockException = e1;
        }
        try {
            LauncherUtils.deleteTryTryAgain(this.customProfileDir(), 6);
        }
        catch (RuntimeException e) {
            if (taskKillException != null || fileLockException != null) {
                e.printStackTrace();
                System.err.print("Perhaps caused by: ");
                if (taskKillException != null) {
                    taskKillException.printStackTrace();
                }
                if (fileLockException != null) {
                    fileLockException.printStackTrace();
                }
                throw new RuntimeException("Couldn't delete custom Firefox profile directory, presumably because task kill failed; see stderr!", e);
            }
            throw e;
        }
        this.closed = true;
    }

    public Process getProcess() {
        return this.process;
    }

    private File customProfileDir() {
        if (this.customProfileDir == null) {
            this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        }
        return this.customProfileDir;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir(), "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            AsyncExecute.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir(), "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
        long subTimeout = timeout - (System.currentTimeMillis() - start);
        try {
            this.waitForFileLockToGoAway(subTimeout, 500L);
        }
        catch (FileLockRemainedException e) {
            throw new RuntimeException("Firefox refused shutdown while preparing a profile", e);
        }
    }

    public static void main(String[] args) throws Exception {
        FirefoxCustomProfileLauncher l = new FirefoxCustomProfileLauncher(4444, "CUSTFF");
        l.launch("http://www.google.com");
        int seconds = 15000;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }

    private class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

