/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class InternetExplorerCustomProxyLauncher
extends AbstractBrowserLauncher {
    protected static final String REG_KEY_SELENIUM_FOLDER = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\";
    protected static final String REG_KEY_BACKUP_READY = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\BackupReady";
    protected static final String REG_KEY_BACKUP_AUTOCONFIG_URL = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\AutoConfigURL";
    protected static final String REG_KEY_BACKUP_MAX_CONNECTIONS_PER_1_0_SVR = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\MaxConnectionsPer1_0Server";
    protected static final String REG_KEY_BACKUP_MAX_CONNECTIONS_PER_1_1_SVR = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\MaxConnectionsPerServer";
    protected static final String REG_KEY_BACKUP_PROXY_ENABLE = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\ProxyEnable";
    protected static final String REG_KEY_BACKUP_PROXY_OVERRIDE = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\ProxyOverride";
    protected static final String REG_KEY_BACKUP_PROXY_SERVER = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\ProxyServer";
    protected static final String REG_KEY_BACKUP_AUTOPROXY_RESULT_CACHE = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\EnableAutoproxyResultCache";
    protected static final String REG_KEY_BACKUP_POPUP_MGR = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\PopupMgr";
    protected static final String REG_KEY_BACKUP_MIME_EXCLUSION_LIST_FOR_CACHE = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\MimeExclusionListForCache";
    protected static String REG_KEY_BASE = "HKEY_CURRENT_USER";
    protected static final String REG_KEY_POPUP_MGR = "\\Software\\Microsoft\\Internet Explorer\\New Windows\\PopupMgr";
    protected static final String REG_KEY_AUTOCONFIG_URL = "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\AutoConfigURL";
    protected static final String REG_KEY_MAX_CONNECTIONS_PER_1_0_SVR = "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\MaxConnectionsPer1_0Server";
    protected static final String REG_KEY_MAX_CONNECTIONS_PER_1_1_SVR = "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\MaxConnectionsPerServer";
    protected static final String REG_KEY_PROXY_ENABLE = "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ProxyEnable";
    protected static final String REG_KEY_PROXY_OVERRIDE = "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ProxyOverride";
    protected static final String REG_KEY_PROXY_SERVER = "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ProxyServer";
    protected static final String REG_KEY_AUTOPROXY_RESULT_CACHE = "\\Software\\Policies\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\EnableAutoproxyResultCache";
    protected static final String REG_KEY_MIME_EXCLUSION_LIST_FOR_CACHE = "\\Software\\Policies\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\MimeExclusionListForCache";
    protected static final String REG_KEY_WARN_ON_FORM_SUBMIT = "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\3\\1601";
    protected static Class popupMgrType;
    private static ArrayList<RegKeyBackup> keys;
    private int port = 8180;
    private File customProxyPACDir;
    private String[] cmdarray;
    private String commandPath;
    private Process process;
    protected boolean customPACappropriate = true;

    public InternetExplorerCustomProxyLauncher(int port, String sessionId) {
        this(port, sessionId, InternetExplorerCustomProxyLauncher.findBrowserLaunchLocation());
    }

    public InternetExplorerCustomProxyLauncher(int port, String sessionId, String browserLaunchLocation) {
        super(sessionId);
        this.init();
        this.commandPath = browserLaunchLocation;
        this.port = port;
        this.sessionId = sessionId;
    }

    protected void init() {
        if (!this.isStaticInitDone()) {
            this.initStatic();
        }
    }

    protected boolean isStaticInitDone() {
        return keys != null;
    }

    protected void initStatic() {
        keys = new ArrayList();
        this.handleEvilPopupMgrBackup();
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_POPUP_MGR, REG_KEY_BACKUP_POPUP_MGR, popupMgrType);
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_AUTOCONFIG_URL, REG_KEY_BACKUP_AUTOCONFIG_URL, String.class);
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_AUTOPROXY_RESULT_CACHE, REG_KEY_BACKUP_AUTOPROXY_RESULT_CACHE, Boolean.TYPE);
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_MIME_EXCLUSION_LIST_FOR_CACHE, REG_KEY_BACKUP_MIME_EXCLUSION_LIST_FOR_CACHE, String.class);
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_PROXY_ENABLE, REG_KEY_BACKUP_PROXY_ENABLE, Boolean.TYPE);
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_PROXY_OVERRIDE, REG_KEY_BACKUP_PROXY_OVERRIDE, Boolean.TYPE);
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_PROXY_SERVER, REG_KEY_BACKUP_PROXY_SERVER, String.class);
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_MAX_CONNECTIONS_PER_1_0_SVR, REG_KEY_BACKUP_MAX_CONNECTIONS_PER_1_0_SVR, Integer.TYPE);
        this.addRegistryKeyToBackupList(REG_KEY_BASE + REG_KEY_MAX_CONNECTIONS_PER_1_1_SVR, REG_KEY_BACKUP_MAX_CONNECTIONS_PER_1_1_SVR, Integer.TYPE);
    }

    protected void handleEvilPopupMgrBackup() {
        popupMgrType = WindowsUtils.discoverRegistryKeyType(REG_KEY_BASE + REG_KEY_POPUP_MGR);
        Class backupPopupMgrType = WindowsUtils.discoverRegistryKeyType(REG_KEY_BACKUP_POPUP_MGR);
        if (popupMgrType == null) {
            if (backupPopupMgrType == null) {
                popupMgrType = Boolean.TYPE;
                return;
            }
            popupMgrType = backupPopupMgrType;
            return;
        }
        if (popupMgrType.equals(backupPopupMgrType)) {
            return;
        }
        if (backupPopupMgrType != null) {
            WindowsUtils.deleteRegistryValue(REG_KEY_BACKUP_POPUP_MGR);
        }
        if (!this.backupIsReady()) {
            return;
        }
        this.turnOffPopupBlocking(REG_KEY_BACKUP_POPUP_MGR);
    }

    protected void turnOffPopupBlocking(String key) {
        if (WindowsUtils.doesRegistryValueExist(key)) {
            WindowsUtils.deleteRegistryValue(key);
        }
        if (popupMgrType.equals(String.class)) {
            WindowsUtils.writeStringRegistryValue(key, "no");
        } else {
            WindowsUtils.writeBooleanRegistryValue(key, false);
        }
    }

    protected void addRegistryKeyToBackupList(String regKey, String backupRegKey, Class clazz) {
        keys.add(new RegKeyBackup(regKey, backupRegKey, clazz));
    }

    public static void setBaseRegKey(String base) {
        REG_KEY_BASE = base;
    }

    protected static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("internetExplorerDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.getProgramFilesPath() + "\\Internet Explorer\\iexplore.exe";
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        File iexploreEXE = AsyncExecute.whichExec("iexplore.exe");
        if (iexploreEXE != null) {
            return iexploreEXE.getAbsolutePath();
        }
        throw new RuntimeException("Internet Explorer couldn't be found in the path!\nPlease add the directory containing iexplore.exe to your PATH environment\nvariable, or explicitly specify a path to IE like this:\n*iexplore c:\\blah\\iexplore.exe");
    }

    public void launch(String url) {
        try {
            if (WindowsUtils.thisIsWindows()) {
                this.backupRegistrySettings();
                this.changeRegistrySettings();
                this.cmdarray = new String[]{this.commandPath, "-new", url};
            } else {
                this.cmdarray = new String[]{this.commandPath, url};
            }
            System.out.println("Launching Internet Explorer...");
            AsyncExecute exe = new AsyncExecute();
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void changeRegistrySettings() throws IOException {
        if (!this.customPACappropriate) {
            if (WindowsUtils.doesRegistryValueExist(REG_KEY_BASE + REG_KEY_AUTOCONFIG_URL)) {
                WindowsUtils.deleteRegistryValue(REG_KEY_BASE + REG_KEY_AUTOCONFIG_URL);
            }
        } else {
            this.customProxyPACDir = LauncherUtils.createCustomProfileDir(this.sessionId);
            if (this.customProxyPACDir.exists()) {
                LauncherUtils.recursivelyDeleteDir(this.customProxyPACDir);
            }
            this.customProxyPACDir.mkdir();
            File proxyPAC = LauncherUtils.makeProxyPAC(this.customProxyPACDir, this.port);
            System.out.println("Modifying registry settings...");
            String newURL = "file://" + proxyPAC.getAbsolutePath().replace('\\', '/');
            WindowsUtils.writeStringRegistryValue(REG_KEY_BASE + REG_KEY_AUTOCONFIG_URL, newURL);
        }
        WindowsUtils.writeBooleanRegistryValue(REG_KEY_BASE + REG_KEY_AUTOPROXY_RESULT_CACHE, false);
        WindowsUtils.writeStringRegistryValue(REG_KEY_BASE + REG_KEY_MIME_EXCLUSION_LIST_FOR_CACHE, "multipart/mixed multipart/x-mixed-replace multipart/x-byteranges text/html");
        this.turnOffPopupBlocking(REG_KEY_BASE + REG_KEY_POPUP_MGR);
        WindowsUtils.writeIntRegistryValue(REG_KEY_BASE + REG_KEY_WARN_ON_FORM_SUBMIT, 0);
        if (WindowsUtils.doesRegistryValueExist(REG_KEY_BASE + REG_KEY_PROXY_OVERRIDE)) {
            WindowsUtils.deleteRegistryValue(REG_KEY_BASE + REG_KEY_PROXY_OVERRIDE);
        }
    }

    public void backupRegistrySettings() {
        if (this.backupIsReady()) {
            return;
        }
        System.out.println("Backing up registry settings...");
        for (RegKeyBackup key : keys) {
            key.backup();
        }
        this.backupReady(true);
    }

    public void restoreRegistrySettings() {
        if (!this.backupIsReady()) {
            return;
        }
        System.out.println("Restoring registry settings (won't affect running browsers)...");
        for (RegKeyBackup key : keys) {
            key.restore();
        }
        this.backupReady(false);
    }

    private boolean backupIsReady() {
        if (!WindowsUtils.doesRegistryValueExist(REG_KEY_BACKUP_READY)) {
            return false;
        }
        return WindowsUtils.readBooleanRegistryValue(REG_KEY_BACKUP_READY);
    }

    private void backupReady(boolean backupReady) {
        WindowsUtils.writeBooleanRegistryValue(REG_KEY_BACKUP_READY, backupReady);
    }

    public void close() {
        Throwable taskKillException = null;
        if (WindowsUtils.thisIsWindows()) {
            this.restoreRegistrySettings();
        }
        if (this.process == null) {
            return;
        }
        AsyncExecute.killProcess(this.process);
        if (this.customPACappropriate) {
            try {
                LauncherUtils.recursivelyDeleteDir(this.customProxyPACDir);
            }
            catch (RuntimeException e) {
                if (taskKillException != null) {
                    e.printStackTrace();
                    System.err.print("Perhaps caused by: ");
                    taskKillException.printStackTrace();
                    throw new RuntimeException("Couldn't delete custom IE proxy directory, presumably because task kill failed; see stderr!", e);
                }
                throw e;
            }
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public static void main(String[] args) {
        InternetExplorerCustomProxyLauncher l = new InternetExplorerCustomProxyLauncher(4444, "CUSTIE");
        l.launch("http://www.google.com/");
        int seconds = 5;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }

    static {
        keys = null;
    }

    private static class RegKeyBackup {
        private String keyOriginal;
        private String keyBackup;
        private Class type;

        public RegKeyBackup(String keyOriginal, String keyBackup, Class type) {
            this.keyOriginal = keyOriginal;
            this.keyBackup = keyBackup;
            this.type = type;
        }

        private boolean backupExists() {
            return WindowsUtils.doesRegistryValueExist(this.keyBackup);
        }

        private boolean originalExists() {
            return WindowsUtils.doesRegistryValueExist(this.keyOriginal);
        }

        private void backup() {
            if (this.originalExists()) {
                this.copy(this.keyOriginal, this.keyBackup);
            } else {
                this.clear(this.keyBackup);
            }
        }

        private void restore() {
            if (this.backupExists()) {
                this.copy(this.keyBackup, this.keyOriginal);
            } else {
                this.clear(this.keyOriginal);
            }
        }

        private void clear(String key) {
            if (WindowsUtils.doesRegistryValueExist(key)) {
                WindowsUtils.deleteRegistryValue(key);
            }
        }

        private void copy(String source, String dest) {
            if (this.type.equals(String.class)) {
                this.copyString(source, dest);
                return;
            }
            if (this.type.equals(Boolean.TYPE)) {
                this.copyBoolean(source, dest);
                return;
            }
            if (this.type.equals(Integer.TYPE)) {
                this.copyInt(source, dest);
                return;
            }
            throw new RuntimeException("Bad type: " + this.type.getName());
        }

        private void copyString(String source, String dest) {
            String data = WindowsUtils.readStringRegistryValue(source);
            WindowsUtils.writeStringRegistryValue(dest, data);
        }

        private void copyBoolean(String source, String dest) {
            boolean data = WindowsUtils.readBooleanRegistryValue(source);
            WindowsUtils.writeBooleanRegistryValue(dest, data);
        }

        private void copyInt(String source, String dest) {
            int data = WindowsUtils.readIntRegistryValue(source);
            WindowsUtils.writeIntRegistryValue(dest, data);
        }
    }
}

