/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.openqa.selenium.NeedsDriver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.environment.GlobalTestEnvironment;
import org.openqa.selenium.environment.TestEnvironment;
import org.openqa.selenium.environment.webserver.AppServer;

public class AbstractDriverTestCase
extends TestCase
implements NeedsDriver {
    protected WebDriver driver;
    protected String simpleTestPage;
    protected String xhtmlTestPage;
    protected String formPage;
    protected String metaRedirectPage;
    protected String redirectPage;
    protected String javascriptPage;
    protected String framesetPage;
    protected String iframePage;
    protected String dragAndDropPage;
    protected String chinesePage;
    protected String nestedPage;

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.driver.setVisible(true);
        TestEnvironment environment = GlobalTestEnvironment.get();
        AppServer appServer = environment.getAppServer();
        this.simpleTestPage = appServer.whereIs("simpleTest.html");
        this.xhtmlTestPage = appServer.whereIs("xhtmlTest.html");
        this.formPage = appServer.whereIs("formPage.html");
        this.metaRedirectPage = appServer.whereIs("meta-redirect.html");
        this.redirectPage = appServer.whereIs("redirect");
        this.javascriptPage = appServer.whereIs("javascriptPage.html");
        this.framesetPage = appServer.whereIs("frameset.html");
        this.iframePage = appServer.whereIs("iframes.html");
        this.dragAndDropPage = appServer.whereIs("dragAndDropTest.html");
        this.chinesePage = appServer.whereIs("cn-test.html");
        this.nestedPage = appServer.whereIs("nestedElements.html");
        String hostName = environment.getAppServer().getHostName();
        String alternateHostName = environment.getAppServer().getAlternateHostName();
        MatcherAssert.assertThat((Object)hostName, (Matcher)Matchers.is((Matcher)IsNot.not((Matcher)Matchers.equalTo((Object)alternateHostName))));
    }
}

