/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.environment.GlobalTestEnvironment;
import org.openqa.selenium.environment.webserver.AppServer;

public class CookieImplementationTest
extends AbstractDriverTestCase {
    public void testAddCookiesWithDifferentPaths() {
        this.driver.get(this.simpleTestPage);
        this.driver.manage().deleteAllCookies();
        Cookie cookie1 = new Cookie("fish", "cod", "/animals");
        Cookie cookie2 = new Cookie("planet", "earth", "/galaxy");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        AppServer appServer = GlobalTestEnvironment.get().getAppServer();
        this.driver.get(appServer.whereIs("animals"));
        Set cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies.contains(cookie1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cookies.contains(cookie2), (Matcher)Matchers.is((Object)false));
        this.driver.get(appServer.whereIs("galaxy"));
        cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies.contains(cookie1), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)cookies.contains(cookie2), (Matcher)Matchers.is((Object)true));
    }

    public void testGetAllCookies() {
        this.driver.get(this.simpleTestPage);
        this.driver.manage().deleteAllCookies();
        Calendar c = Calendar.getInstance();
        c.set(2009, 0, 1);
        Cookie cookie1 = new Cookie("fish", "cod", "", c.getTime());
        Cookie cookie2 = new Cookie("planet", "earth");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        Set cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies.contains(cookie1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cookies.contains(cookie2), (Matcher)Matchers.is((Object)true));
    }

    @Ignore(value="ie")
    public void testCookieIntegrity() {
        String url = GlobalTestEnvironment.get().getAppServer().whereElseIs("animals");
        this.driver.get(url);
        this.driver.manage().deleteAllCookies();
        Calendar c = Calendar.getInstance();
        c.set(2009, 0, 1);
        Cookie cookie1 = new Cookie("fish", "cod", "/animals", c.getTime());
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        Set cookies = options.getCookies();
        Iterator iter = cookies.iterator();
        Cookie retrievedCookie = null;
        while (iter.hasNext()) {
            Cookie temp = (Cookie)iter.next();
            if (!cookie1.equals((Object)temp)) continue;
            retrievedCookie = temp;
            break;
        }
        MatcherAssert.assertThat(retrievedCookie, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat(retrievedCookie, (Matcher)Matchers.equalTo((Object)cookie1));
        MatcherAssert.assertThat((Object)retrievedCookie.getValue(), (Matcher)Matchers.equalTo((Object)cookie1.getValue()));
        MatcherAssert.assertThat((Object)retrievedCookie.isSecure(), (Matcher)Matchers.equalTo((Object)cookie1.isSecure()));
    }

    @Ignore(value="safari")
    public void testDeleteAllCookies() {
        this.driver.get(this.simpleTestPage);
        Cookie cookie1 = new Cookie("fish", "cod");
        Cookie cookie2 = new Cookie("planet", "earth");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        Set cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies.contains(cookie1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cookies.contains(cookie2), (Matcher)Matchers.is((Object)true));
        options.deleteAllCookies();
        this.driver.get(this.simpleTestPage);
        cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies.contains(cookie1), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)cookies.contains(cookie2), (Matcher)Matchers.is((Object)false));
    }

    @Ignore(value="safari")
    public void testDeleteCookie() {
        this.driver.get(this.simpleTestPage);
        Cookie cookie1 = new Cookie("fish", "cod");
        Cookie cookie2 = new Cookie("planet", "earth");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        options.deleteCookie(cookie1);
        Set cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)cookies, (Matcher)Matchers.hasItem((Object)cookie2));
    }

    public void testDeleteCookieWithName() {
        this.driver.get(this.simpleTestPage);
        this.driver.manage().deleteAllCookies();
        String cookieOneName = "fish";
        String cookieTwoName = "planet";
        String cookieThreeName = "three";
        Cookie cookie1 = new Cookie(cookieOneName, "cod");
        Cookie cookie2 = new Cookie(cookieTwoName, "earth");
        Cookie cookie3 = new Cookie(cookieThreeName, "three");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        options.addCookie(cookie3);
        options.deleteCookieNamed(cookieOneName);
        options.deleteCookieNamed(cookieTwoName);
        Set cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)cookie1)));
        MatcherAssert.assertThat((Object)cookies, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)cookie2)));
        MatcherAssert.assertThat((Object)cookies, (Matcher)Matchers.hasItem((Object)cookie3));
    }

    public void testShouldNotDeleteCookiesWithASimilarName() {
        this.driver.get(this.simpleTestPage);
        this.driver.manage().deleteAllCookies();
        String cookieOneName = "fish";
        Cookie cookie1 = new Cookie(cookieOneName, "cod");
        Cookie cookie2 = new Cookie(cookieOneName + "x", "earth");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        options.deleteCookieNamed(cookieOneName);
        Set cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)cookie1)));
        MatcherAssert.assertThat((Object)cookies, (Matcher)Matchers.hasItem((Object)cookie2));
    }

    public void testGetCookieDoesNotRetriveBeyondCurrentDomain() {
        this.driver.get(this.simpleTestPage);
        this.driver.manage().deleteAllCookies();
        Cookie cookie1 = new Cookie("fish", "cod");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        String url = GlobalTestEnvironment.get().getAppServer().whereElseIs("");
        this.driver.get(url);
        Set cookies = options.getCookies();
        MatcherAssert.assertThat((Object)cookies, (Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)cookie1)));
    }
}

