/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Date;
import junit.framework.TestCase;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.internal.ReturnedCookie;

public class CookieTest
extends TestCase {
    public void testCanCreateAWellFormedCookie() {
        new ReturnedCookie("Fish", "cod", "", "", null, false);
    }

    public void testShouldThrowAnExceptionWhenTheDomainIsBad() {
        try {
            new ReturnedCookie("Fish", "cod", "127.0.0.0.1", null, null, false);
            CookieTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testShouldThrowAnExceptionWhenSemiColonExistsInTheCookieAttribute() {
        try {
            new ReturnedCookie("hi;hi", "value", null, null, null, false);
            CookieTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testShouldThrowAnExceptionTheNameIsNull() {
        try {
            new ReturnedCookie(null, "value", null, null, null, false);
            CookieTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Ignore(value="all", reason="Weakened constraints to allow IE driver to be implemented")
    public void testEquals() {
        ReturnedCookie cookie1 = new ReturnedCookie("Fish", "cod", "", "", null, false);
        ReturnedCookie cookie2 = new ReturnedCookie("Fish", "", "", "", new Date(0L), true);
        CookieTest.assertEquals((Object)cookie1, (Object)cookie2);
        cookie2 = new ReturnedCookie("Fish", "cod", "", "/", null, false);
        CookieTest.assertFalse((boolean)cookie1.equals((Object)cookie2));
        cookie2 = new ReturnedCookie("fish", "cod", "", "", null, false);
        CookieTest.assertFalse((boolean)cookie1.equals((Object)cookie2));
        cookie2 = new ReturnedCookie("Fish", "cod", "example.com", "", null, false);
        CookieTest.assertFalse((boolean)cookie1.equals((Object)cookie2));
    }

    @Ignore(value="all", reason="Weakened constraints to allow IE driver to be implemented")
    public void testHashCode() {
        ReturnedCookie cookie1 = new ReturnedCookie("Fish", "cod", "", "", null, false);
        ReturnedCookie cookie2 = new ReturnedCookie("Fish", "", "", "", new Date(0L), true);
        CookieTest.assertEquals((int)cookie1.hashCode(), (int)cookie2.hashCode());
        cookie2 = new ReturnedCookie("Fish", "cod", "", "/", null, false);
        CookieTest.assertFalse((cookie1.hashCode() == cookie2.hashCode() ? 1 : 0) != 0);
        cookie2 = new ReturnedCookie("fish", "cod", "", "", null, false);
        CookieTest.assertFalse((cookie1.hashCode() == cookie2.hashCode() ? 1 : 0) != 0);
        cookie2 = new ReturnedCookie("Fish", "cod", "example.com", "", null, false);
        CookieTest.assertFalse((cookie1.hashCode() == cookie2.hashCode() ? 1 : 0) != 0);
    }

    public void testCookiesShouldAllowSecureToBeSet() {
        ReturnedCookie cookie = new ReturnedCookie("name", "value", "", "/", new Date(), true);
        CookieTest.assertTrue((boolean)cookie.isSecure());
    }
}

