/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.awt.Point;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.Speed;

public class DragAndDropTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    @Ignore(value="ie, safari, htmlunit")
    public void testDragAndDrop() throws Exception {
        this.driver.get(this.dragAndDropPage);
        RenderedWebElement img = (RenderedWebElement)this.driver.findElement(By.id((String)"test1"));
        Point expectedLocation = img.getLocation();
        this.drag(img, expectedLocation, 500, 300);
        DragAndDropTest.assertEquals((Object)expectedLocation, (Object)img.getLocation());
        this.driver.manage().setSpeed(Speed.SLOW);
        this.drag(img, expectedLocation, -100, -50);
        DragAndDropTest.assertEquals((Object)expectedLocation, (Object)img.getLocation());
        this.driver.manage().setSpeed(Speed.MEDIUM);
        this.drag(img, expectedLocation, 0, 0);
        DragAndDropTest.assertEquals((Object)expectedLocation, (Object)img.getLocation());
        this.driver.manage().setSpeed(Speed.FAST);
        this.drag(img, expectedLocation, 1, -1);
        DragAndDropTest.assertEquals((Object)expectedLocation, (Object)img.getLocation());
    }

    @JavascriptEnabled
    @Ignore(value="ie, safari, htmlunit")
    public void testDragAndDropToElement() {
        this.driver.get(this.dragAndDropPage);
        RenderedWebElement img1 = (RenderedWebElement)this.driver.findElement(By.id((String)"test1"));
        RenderedWebElement img2 = (RenderedWebElement)this.driver.findElement(By.id((String)"test2"));
        img1.dragAndDropBy(100, 100);
        img2.dragAndDropOn(img1);
        DragAndDropTest.assertEquals((Object)img1.getLocation(), (Object)img2.getLocation());
    }

    @JavascriptEnabled
    @Ignore(value="ie, safari, htmlunit")
    public void testElementInDiv() {
        this.driver.get(this.dragAndDropPage);
        RenderedWebElement img = (RenderedWebElement)this.driver.findElement(By.id((String)"test3"));
        Point expectedLocation = img.getLocation();
        this.drag(img, expectedLocation, 100, 100);
        DragAndDropTest.assertEquals((Object)expectedLocation, (Object)img.getLocation());
    }

    @JavascriptEnabled
    @Ignore(value="ie, safari, htmlunit")
    public void testDragTooFar() {
        this.driver.get(this.dragAndDropPage);
        RenderedWebElement img = (RenderedWebElement)this.driver.findElement(By.id((String)"test1"));
        img.dragAndDropBy(Integer.MIN_VALUE, Integer.MIN_VALUE);
        DragAndDropTest.assertEquals((Object)new Point(0, 0), (Object)img.getLocation());
        img.dragAndDropBy(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @JavascriptEnabled
    @Ignore(value="ie, safari, htmlunit")
    public void testMouseSpeed() throws Exception {
        this.driver.get(this.dragAndDropPage);
        this.driver.manage().setSpeed(Speed.SLOW);
        DragAndDropTest.assertEquals((Object)Speed.SLOW, (Object)this.driver.manage().getSpeed());
        this.driver.manage().setSpeed(Speed.MEDIUM);
        DragAndDropTest.assertEquals((Object)Speed.MEDIUM, (Object)this.driver.manage().getSpeed());
        this.driver.manage().setSpeed(Speed.FAST);
        DragAndDropTest.assertEquals((Object)Speed.FAST, (Object)this.driver.manage().getSpeed());
    }

    private void drag(RenderedWebElement elem, Point expectedLocation, int moveRightBy, int moveDownBy) {
        elem.dragAndDropBy(moveRightBy, moveDownBy);
        expectedLocation.move(expectedLocation.x + moveRightBy, expectedLocation.y + moveDownBy);
    }
}

