/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.WebElement;

public class ElementAttributeTest
extends AbstractDriverTestCase {
    @Ignore(value="ie, safari")
    public void testShouldReturnNullWhenGettingTheValueOfAnAttributeThatIsNotListed() {
        this.driver.get(this.simpleTestPage);
        WebElement head = this.driver.findElement(By.xpath((String)"/html"));
        String attribute = head.getAttribute("cheese");
        MatcherAssert.assertThat((Object)attribute, (Matcher)Matchers.is((Matcher)IsNull.nullValue()));
    }

    @Ignore(value="safari")
    public void testShouldReturnEmptyAttributeValuesWhenPresentAndTheValueIsActuallyEmpty() {
        this.driver.get(this.simpleTestPage);
        WebElement body = this.driver.findElement(By.xpath((String)"//body"));
        MatcherAssert.assertThat((Object)body.getAttribute("style"), (Matcher)Matchers.equalTo((Object)""));
    }

    @Ignore(value="safari")
    public void testShouldReturnTheValueOfTheDisabledAttrbuteEvenIfItIsMissing() {
        this.driver.get(this.formPage);
        WebElement inputElement = this.driver.findElement(By.xpath((String)"//input[@id='working']"));
        MatcherAssert.assertThat((Object)inputElement.getAttribute("disabled"), (Matcher)Matchers.equalTo((Object)"false"));
    }

    @Ignore(value="ie, htmlunit, safari")
    public void testShouldReturnTheValueOfTheIndexAttrbuteEvenIfItIsMissing() {
        this.driver.get(this.formPage);
        WebElement multiSelect = this.driver.findElement(By.id((String)"multi"));
        List options = multiSelect.getChildrenOfType("option");
        MatcherAssert.assertThat((Object)((WebElement)options.get(1)).getAttribute("index"), (Matcher)Matchers.equalTo((Object)"1"));
    }

    @Ignore(value="safari")
    public void testShouldIndicateTheElementsThatAreDisabledAreNotEnabled() {
        this.driver.get(this.formPage);
        WebElement inputElement = this.driver.findElement(By.xpath((String)"//input[@id='notWorking']"));
        MatcherAssert.assertThat((Object)inputElement.isEnabled(), (Matcher)Matchers.is((Object)false));
        inputElement = this.driver.findElement(By.xpath((String)"//input[@id='working']"));
        MatcherAssert.assertThat((Object)inputElement.isEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Ignore(value="safari")
    public void testShouldIndicateWhenATextAreaIsDisabled() {
        this.driver.get(this.formPage);
        WebElement textArea = this.driver.findElement(By.xpath((String)"//textarea[@id='notWorkingArea']"));
        MatcherAssert.assertThat((Object)textArea.isEnabled(), (Matcher)Matchers.is((Object)false));
    }

    @Ignore(value="safari")
    public void testShouldReturnTheValueOfCheckedForACheckboxEvenIfItLacksThatAttribute() {
        this.driver.get(this.formPage);
        WebElement checkbox = this.driver.findElement(By.xpath((String)"//input[@id='checky']"));
        MatcherAssert.assertThat((Object)checkbox.getAttribute("checked"), (Matcher)Matchers.equalTo((Object)"false"));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)checkbox.getAttribute("checked"), (Matcher)Matchers.equalTo((Object)"true"));
    }

    public void testShouldReturnTheValueOfSelectedForRadioButtonsEvenIfTheyLackThatAttribute() {
    }

    @Ignore(value="safari")
    public void testShouldReturnTheValueOfSelectedForOptionsInSelectsEvenIfTheyLackThatAttribute() {
        this.driver.get(this.formPage);
        WebElement selectBox = this.driver.findElement(By.xpath((String)"//select[@name='selectomatic']"));
        List options = selectBox.getChildrenOfType("option");
        WebElement one = (WebElement)options.get(0);
        WebElement two = (WebElement)options.get(1);
        MatcherAssert.assertThat((Object)one.isSelected(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)two.isSelected(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)one.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)two.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"false"));
    }

    @Ignore(value="safari")
    public void testShouldReturnValueOfClassAttributeOfAnElement() {
        this.driver.get(this.xhtmlTestPage);
        WebElement heading = this.driver.findElement(By.xpath((String)"//h1"));
        String className = heading.getAttribute("class");
        MatcherAssert.assertThat((Object)className, (Matcher)Matchers.equalTo((Object)"header"));
    }

    public void testShouldReturnTheContentsOfATextAreaAsItsValue() {
        this.driver.get(this.formPage);
        String value = this.driver.findElement(By.id((String)"withText")).getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)"Example text"));
    }

    @Ignore(value="all", reason="This is probably a meaningless test")
    public void testShouldReturnTheValueOfTheStyleAttribute() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.xpath((String)"//form[3]"));
        String style = element.getAttribute("style");
        MatcherAssert.assertThat((Object)style, (Matcher)Matchers.equalTo((Object)"display: block"));
    }
}

