/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class ElementFindingTest
extends AbstractDriverTestCase {
    public void testShouldReturnTitleOfPageIfSet() {
        this.driver.get(this.xhtmlTestPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
        this.driver.get(this.simpleTestPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Hello WebDriver"));
    }

    public void testShouldNotBeAbleToLocateASingleElementThatDoesNotExist() {
        this.driver.get(this.formPage);
        try {
            this.driver.findElement(By.id((String)"nonExistantButton"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldBeAbleToClickOnLinkIdentifiedByText() {
        this.driver.get(this.xhtmlTestPage);
        this.driver.findElement(By.linkText((String)"click me")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testDriverShouldBeAbleToFindElementsAfterLoadingMoreThanOnePageAtATime() {
        this.driver.get(this.formPage);
        this.driver.get(this.xhtmlTestPage);
        this.driver.findElement(By.linkText((String)"click me")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void shouldBeAbleToClickOnLinkIdentifiedById() {
        this.driver.get(this.xhtmlTestPage);
        this.driver.findElement(By.id((String)"linkId")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldThrowAnExceptionWhenThereIsNoLinkToClickAndItIsFoundWithLinkText() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.findElement(By.linkText((String)"Not here either"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Ignore(value="safari")
    public void testShouldfindAnElementBasedOnId() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.id((String)"checky"));
        MatcherAssert.assertThat((Object)element.isSelected(), (Matcher)Matchers.is((Object)false));
    }

    public void testShouldNotBeAbleTofindElementsBasedOnIdIfTheElementIsNotThere() {
        this.driver.get(this.formPage);
        try {
            this.driver.findElement(By.id((String)"notThere"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToFindChildrenOfANode() {
        this.driver.get(this.xhtmlTestPage);
        List elements = this.driver.findElements(By.xpath((String)"/html/head"));
        WebElement head = (WebElement)elements.get(0);
        List importedScripts = head.getChildrenOfType("script");
        MatcherAssert.assertThat((Object)importedScripts.size(), (Matcher)Matchers.equalTo((Object)2));
    }

    public void testShouldFindElementsByName() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.name((String)"checky"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"furrfu"));
    }

    public void testShouldFindElementsByClass() {
        this.driver.get(this.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"extraDiv"));
        ElementFindingTest.assertTrue((boolean)element.getText().startsWith("Another div starts here."));
    }

    public void testShouldFindElementsByClassWhenItIsTheFirstNameAmongMany() {
        this.driver.get(this.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"nameA"));
        MatcherAssert.assertThat((Object)element.getText(), (Matcher)Matchers.equalTo((Object)"An H2 title"));
    }

    public void testShouldFindElementsByClassWhenItIsTheLastNameAmongMany() {
        this.driver.get(this.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"nameC"));
        MatcherAssert.assertThat((Object)element.getText(), (Matcher)Matchers.equalTo((Object)"An H2 title"));
    }

    public void testShouldFindElementsByClassWhenItIsInTheMiddleAmongMany() {
        this.driver.get(this.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"nameBnoise"));
        MatcherAssert.assertThat((Object)element.getText(), (Matcher)Matchers.equalTo((Object)"An H2 title"));
    }

    public void testShouldNotFindElementsByClassWhenTheNameQueriedIsShorterThanCandidateName() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.findElement(By.className((String)"nameB"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToFindMultipleElementsByXPath() {
        this.driver.get(this.xhtmlTestPage);
        List elements = this.driver.findElements(By.xpath((String)"//div"));
        ElementFindingTest.assertTrue((elements.size() > 1 ? 1 : 0) != 0);
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToFindMultipleElementsByLinkText() {
        this.driver.get(this.xhtmlTestPage);
        List elements = this.driver.findElements(By.linkText((String)"click me"));
        ElementFindingTest.assertTrue((String)("Expected 2 links, got " + elements.size()), (elements.size() == 2 ? 1 : 0) != 0);
    }

    @Ignore(value="safari, ie, remote")
    public void testShouldBeAbleToFindMultipleElementsByPartialLinkText() {
        this.driver.get(this.xhtmlTestPage);
        List elements = this.driver.findElements(By.partialLinkText((String)"ick me"));
        ElementFindingTest.assertTrue((elements.size() == 2 ? 1 : 0) != 0);
    }

    @Ignore(value="safari, ie, remote")
    public void testShouldBeAbleToFindElementByPartialLinkText() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.findElement(By.partialLinkText((String)"anon"));
        }
        catch (NoSuchElementException e) {
            ElementFindingTest.fail((String)"Expected element to be found");
        }
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToFindMultipleElementsByName() {
        this.driver.get(this.nestedPage);
        List elements = this.driver.findElements(By.name((String)"checky"));
        ElementFindingTest.assertTrue((elements.size() > 1 ? 1 : 0) != 0);
    }

    @Ignore(value="safari, firefox")
    public void testShouldBeAbleToFindMultipleElementsById() {
        this.driver.get(this.nestedPage);
        List elements = this.driver.findElements(By.id((String)"2"));
        ElementFindingTest.assertTrue((elements.size() > 1 ? 1 : 0) != 0);
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToFindMultipleElementsByClassName() {
        this.driver.get(this.xhtmlTestPage);
        List elements = this.driver.findElements(By.className((String)"nameC"));
        ElementFindingTest.assertTrue((elements.size() > 1 ? 1 : 0) != 0);
    }

    @Ignore(value="safari")
    public void testWhenFindingByNameShouldNotReturnById() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.name((String)"id-name1"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"name"));
        element = this.driver.findElement(By.id((String)"id-name1"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"id"));
        element = this.driver.findElement(By.name((String)"id-name2"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"name"));
        element = this.driver.findElement(By.id((String)"id-name2"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"id"));
    }

    @Ignore(value="safari")
    public void testShouldFindGrandChildren() {
        this.driver.get(this.formPage);
        WebElement form = this.driver.findElement(By.id((String)"nested_form"));
        form.findElement(By.name((String)"x"));
    }

    @Ignore(value="safari")
    public void testShouldNotFindElementOutSideTree() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.name((String)"login"));
        try {
            element.findElement(By.name((String)"x"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Ignore(value="safari")
    public void testShouldReturnElementsThatDoNotSupportTheNameProperty() {
        this.driver.get(this.nestedPage);
        this.driver.findElement(By.name((String)"div1"));
    }

    public void testShouldFindHiddenElementsByName() {
        this.driver.get(this.formPage);
        try {
            this.driver.findElement(By.name((String)"hidden"));
        }
        catch (NoSuchElementException e) {
            ElementFindingTest.fail((String)"Expected to be able to find hidden element");
        }
    }
}

