/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.ArrayList;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public class ExecutingJavascriptTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAString() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.xhtmlTestPage);
        Object result = this.executeScript("return document.title;", new Object[0]);
        ExecutingJavascriptTest.assertTrue((boolean)(result instanceof String));
        ExecutingJavascriptTest.assertEquals((Object)"XHTML Test Page", (Object)result);
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnALong() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.nestedPage);
        Object result = this.executeScript("return document.getElementsByName('checky').length;", new Object[0]);
        ExecutingJavascriptTest.assertTrue((String)result.getClass().getName(), (boolean)(result instanceof Long));
        ExecutingJavascriptTest.assertTrue(((Long)result > 1L ? 1 : 0) != 0);
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAWebElement() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.xhtmlTestPage);
        Object result = this.executeScript("return document.getElementById('id1');", new Object[0]);
        ExecutingJavascriptTest.assertNotNull((Object)result);
        ExecutingJavascriptTest.assertTrue((boolean)(result instanceof WebElement));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnABoolean() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.xhtmlTestPage);
        Object result = this.executeScript("return true;", new Object[0]);
        ExecutingJavascriptTest.assertNotNull((Object)result);
        ExecutingJavascriptTest.assertTrue((boolean)(result instanceof Boolean));
        ExecutingJavascriptTest.assertTrue((boolean)((Boolean)result));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldThrowAnExceptionWhenTheJavascriptIsBad() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.xhtmlTestPage);
        try {
            this.executeScript("return squiggle();", new Object[0]);
            ExecutingJavascriptTest.fail((String)"Expected an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToCallFunctionsDefinedOnThePage() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        this.executeScript("displayMessage('I like cheese');", new Object[0]);
        String text = this.driver.findElement(By.id((String)"result")).getText();
        ExecutingJavascriptTest.assertEquals((String)"I like cheese", (String)text.trim());
    }

    private Object executeScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.driver).executeScript(script, args);
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToPassAStringAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        String value = (String)this.executeScript("return arguments[0] == 'fish' ? 'fish' : 'not fish';", "fish");
        ExecutingJavascriptTest.assertEquals((String)"fish", (String)value);
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToPassABooleanAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        boolean value = (Boolean)this.executeScript("return arguments[0] == true;", true);
        ExecutingJavascriptTest.assertTrue((boolean)value);
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToPassANumberAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        long value = (Long)this.executeScript("return arguments[0] == 1 ? 1 : 0;", 1);
        ExecutingJavascriptTest.assertEquals((long)1L, (long)value);
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToPassAWebElementAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        WebElement button = this.driver.findElement(By.id((String)"plainButton"));
        String value = (String)this.executeScript("arguments[0]['flibble'] = arguments[0].getAttribute('id'); return arguments[0]['flibble'];", button);
        ExecutingJavascriptTest.assertEquals((String)"plainButton", (String)value);
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldThrowAnExceptionIfAnArgumentIsNotValid() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        try {
            this.executeScript("return arguments[0];", new ArrayList());
            ExecutingJavascriptTest.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToPassInMoreThanOneArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        String result = (String)this.executeScript("return arguments[0] + arguments[1];", "one", "two");
        ExecutingJavascriptTest.assertEquals((String)"onetwo", (String)result);
    }
}

