/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class FormHandlingTest
extends AbstractDriverTestCase {
    public void testShouldClickOnSubmitInputElements() {
        this.driver.get(this.formPage);
        this.driver.findElement(By.id((String)"submitButton")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testClickingOnUnclickableElementsDoesNothing() {
        this.driver.get(this.formPage);
        try {
            this.driver.findElement(By.xpath((String)"//body")).click();
        }
        catch (Exception e) {
            e.printStackTrace();
            FormHandlingTest.fail((String)"Clicking on the unclickable should be a no-op");
        }
    }

    public void testShouldBeAbleToClickImageButtons() {
        this.driver.get(this.formPage);
        this.driver.findElement(By.id((String)"imageButton")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    @Ignore(value="safari", reason="Test fails")
    public void testShouldBeAbleToSubmitForms() {
        this.driver.get(this.formPage);
        this.driver.findElement(By.name((String)"login")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    @Ignore(value="safari", reason="Test fails")
    public void testShouldSubmitAFormWhenAnyInputElementWithinThatFormIsSubmitted() {
        this.driver.get(this.formPage);
        this.driver.findElement(By.id((String)"checky")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    @Ignore(value="safari", reason="Test fails")
    public void testShouldSubmitAFormWhenAnyElementWihinThatFormIsSubmitted() {
        this.driver.get(this.formPage);
        this.driver.findElement(By.xpath((String)"//form/p")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldNotBeAbleToSubmitAFormThatDoesNotExist() {
        this.driver.get(this.formPage);
        try {
            this.driver.findElement(By.name((String)"there is no spoon")).submit();
            FormHandlingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldBeAbleToEnterTextIntoATextAreaBySettingItsValue() {
        this.driver.get(this.javascriptPage);
        WebElement textarea = this.driver.findElement(By.id((String)"keyUpArea"));
        String cheesey = "Brie and cheddar";
        textarea.sendKeys(new CharSequence[]{cheesey});
        MatcherAssert.assertThat((Object)textarea.getValue(), (Matcher)Matchers.equalTo((Object)cheesey));
    }

    public void testShouldEnterDataIntoFormFields() {
        this.driver.get(this.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.xpath((String)"//form[@name='someForm']/input[@id='username']"));
        String originalValue = element.getValue();
        MatcherAssert.assertThat((Object)originalValue, (Matcher)Matchers.equalTo((Object)"change"));
        element.clear();
        element.sendKeys(new CharSequence[]{"some text"});
        element = this.driver.findElement(By.xpath((String)"//form[@name='someForm']/input[@id='username']"));
        String newFormValue = element.getValue();
        MatcherAssert.assertThat((Object)newFormValue, (Matcher)Matchers.equalTo((Object)"some text"));
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToSelectACheckBox() {
        this.driver.get(this.formPage);
        WebElement checkbox = this.driver.findElement(By.id((String)"checky"));
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)false));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)true));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)true));
    }

    @Ignore(value="safari")
    public void testShouldToggleTheCheckedStateOfACheckbox() {
        this.driver.get(this.formPage);
        WebElement checkbox = this.driver.findElement(By.id((String)"checky"));
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)false));
        checkbox.toggle();
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)true));
        checkbox.toggle();
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)false));
    }

    @Ignore(value="safari")
    public void testTogglingACheckboxShouldReturnItsCurrentState() {
        this.driver.get(this.formPage);
        WebElement checkbox = this.driver.findElement(By.id((String)"checky"));
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)false));
        boolean isChecked = checkbox.toggle();
        MatcherAssert.assertThat((Object)isChecked, (Matcher)Matchers.is((Object)true));
        isChecked = checkbox.toggle();
        MatcherAssert.assertThat((Object)isChecked, (Matcher)Matchers.is((Object)false));
    }

    @Ignore(value="safari")
    public void testShouldNotBeAbleToSelectSomethingThatIsDisabled() {
        this.driver.get(this.formPage);
        WebElement radioButton = this.driver.findElement(By.id((String)"nothing"));
        MatcherAssert.assertThat((Object)radioButton.isEnabled(), (Matcher)Matchers.is((Object)false));
        try {
            radioButton.setSelected();
            FormHandlingTest.fail((String)"Should not have succeeded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Ignore(value="safari", reason="IE: Fails test. Safari: Not implemented")
    public void testShouldBeAbleToSelectARadioButton() {
        this.driver.get(this.formPage);
        WebElement radioButton = this.driver.findElement(By.id((String)"peas"));
        MatcherAssert.assertThat((Object)radioButton.isSelected(), (Matcher)Matchers.is((Object)false));
        radioButton.setSelected();
        MatcherAssert.assertThat((Object)radioButton.isSelected(), (Matcher)Matchers.is((Object)true));
    }

    @Ignore(value="ie", reason="Fails test")
    public void testShouldThrowAnExceptionWhenTogglingTheStateOfARadioButton() {
        this.driver.get(this.formPage);
        WebElement radioButton = this.driver.findElement(By.id((String)"cheese"));
        try {
            radioButton.toggle();
            FormHandlingTest.fail((String)"You should not be able to toggle a radio button");
        }
        catch (UnsupportedOperationException e) {
            MatcherAssert.assertThat((Object)e.getMessage().contains("toggle"), (Matcher)Matchers.is((Object)true));
        }
    }

    @Ignore(value="safari", reason="Test fails")
    public void testShouldBeAbleToAlterTheContentsOfAFileUploadInputElement() throws Exception {
        this.driver.get(this.formPage);
        WebElement uploadElement = this.driver.findElement(By.id((String)"upload"));
        MatcherAssert.assertThat((Object)uploadElement.getValue(), (Matcher)Matchers.equalTo((Object)""));
        File file = File.createTempFile("test", "txt");
        file.deleteOnExit();
        uploadElement.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        File value = new File(uploadElement.getValue());
        MatcherAssert.assertThat((Object)value.getCanonicalPath(), (Matcher)Matchers.equalTo((Object)file.getCanonicalPath()));
    }

    public void testShouldThrowAnExceptionWhenSelectingAnUnselectableElement() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.xpath((String)"//title"));
        try {
            element.setSelected();
            FormHandlingTest.fail((String)"Should not have succeeded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSendingKeyboardEventsShouldAppendTextInInputs() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.id((String)"working"));
        element.sendKeys(new CharSequence[]{"Some"});
        String value = element.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)"Some"));
        element.sendKeys(new CharSequence[]{" text"});
        value = element.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)"Some text"));
    }

    @Ignore(value="ie, safari", reason="Not implemented going to the end of the line first")
    public void testSendingKeyboardEventsShouldAppendTextinTextAreas() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.id((String)"withText"));
        element.sendKeys(new CharSequence[]{". Some text"});
        String value = element.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)"Example text. Some text"));
    }

    public void testShouldBeAbleToClearTextFromInputElements() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.id((String)"working"));
        element.sendKeys(new CharSequence[]{"Some text"});
        String value = element.getValue();
        MatcherAssert.assertThat((Object)value.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        element.clear();
        value = element.getValue();
        MatcherAssert.assertThat((Object)value.length(), (Matcher)Matchers.is((Object)0));
    }

    public void testShouldBeAbleToClearTextFromTextAreas() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.id((String)"withText"));
        element.sendKeys(new CharSequence[]{"Some text"});
        String value = element.getValue();
        MatcherAssert.assertThat((Object)value.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        element.clear();
        value = element.getValue();
        MatcherAssert.assertThat((Object)value.length(), (Matcher)Matchers.is((Object)0));
    }
}

