/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NoDriverAfterTest;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebElement;

public class FrameSwitchingTest
extends AbstractDriverTestCase {
    @Ignore(value="safari")
    public void testShouldContinueToReferToTheSameFrameOnceItHasBeenSelected() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame(2);
        WebElement checkbox = this.driver.findElement(By.xpath((String)"//input[@name='checky']"));
        checkbox.toggle();
        checkbox.submit();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.xpath((String)"//p")).getText(), (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    @Ignore(value="safari", reason="Test fails")
    public void testShouldAutomaticallyUseTheFirstFrameOnAPage() {
        this.driver.get(this.framesetPage);
        WebElement pageNumber = this.driver.findElement(By.xpath((String)"//span[@id='pageNumber']"));
        MatcherAssert.assertThat((Object)pageNumber.getText().trim(), (Matcher)Matchers.equalTo((Object)"1"));
    }

    @Ignore(value="safari", reason="Test fails")
    public void testShouldFocusOnTheReplacementWhenAFrameFollowsALinkToA_TopTargettedPage() {
        this.driver.get(this.framesetPage);
        this.driver.findElement(By.linkText((String)"top")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
    }

    public void testShouldNotAutomaticallySwitchFocusToAnIFrameWhenAPageContainingThemIsLoaded() {
        this.driver.get(this.iframePage);
        this.driver.findElement(By.id((String)"iframe_page_heading"));
    }

    @Ignore(value="safari")
    public void testShouldAllowAUserToSwitchFromAnIframeBackToTheMainContentOfThePage() {
        this.driver.get(this.iframePage);
        this.driver.switchTo().frame(0);
        try {
            this.driver.switchTo().defaultContent();
            this.driver.findElement(By.id((String)"iframe_page_heading"));
        }
        catch (Exception e) {
            FrameSwitchingTest.fail((String)"Should have switched back to main content");
        }
    }

    @Ignore(value="safari")
    public void testShouldAllowTheUserToSwitchToAnIFrameAndRemainFocusedOnIt() {
        this.driver.get(this.iframePage);
        this.driver.switchTo().frame(0);
        this.driver.findElement(By.id((String)"submitButton")).click();
        String hello = this.driver.findElement(By.id((String)"greeting")).getText();
        MatcherAssert.assertThat((Object)hello, (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToSelectAFrameByName() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("second");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"2"));
    }

    @Ignore(value="safari")
    public void testShouldSelectChildFramesByUsingADotSeparatedString() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("fourth.child2");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"11"));
    }

    @Ignore(value="safari")
    public void testShouldSwitchToChildFramesTreatingNumbersAsIndex() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("fourth.1");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"11"));
    }

    @NoDriverAfterTest
    @Ignore(value="safari")
    public void testClosingTheFinalBrowserWindowShouldNotCauseAnExceptionToBeThrown() {
        this.driver.get(this.simpleTestPage);
        try {
            this.driver.close();
        }
        catch (Exception e) {
            FrameSwitchingTest.fail((String)("This is not expected. " + e.getMessage()));
        }
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToFlipToAFrameIdentifiedByItsId() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("fifth");
        try {
            this.driver.findElement(By.id((String)"username"));
        }
        catch (NoSuchElementException e) {
            FrameSwitchingTest.fail((String)"Driver did not switch by frame id");
        }
    }

    @Ignore(value="safari")
    public void testShouldThrowAnExceptionWhenAFrameCannotBeFound() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.switchTo().frame("Nothing here");
            FrameSwitchingTest.fail((String)"Should not have been able to switch");
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    @Ignore(value="safari")
    public void testShouldThrowAnExceptionWhenAFrameCannotBeFoundByIndex() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.switchTo().frame(27);
            FrameSwitchingTest.fail((String)"Should not have been able to switch");
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToFindElementsInIframesByName() {
        this.driver.get(this.iframePage);
        this.driver.switchTo().frame("iframe1");
        WebElement element = this.driver.findElement(By.name((String)"id-name1"));
        FrameSwitchingTest.assertNotNull((Object)element);
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToFindElementsInIframesByXPath() {
        this.driver.get(this.iframePage);
        this.driver.switchTo().frame("iframe1");
        WebElement element = this.driver.findElement(By.xpath((String)"//*[@id = 'changeme']"));
        FrameSwitchingTest.assertNotNull((Object)element);
    }

    @Ignore(value="safari")
    public void testGetCurrentUrl() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("second");
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost:3000/page/2?title=Fish"));
        this.driver.get(this.iframePage);
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost:3000/iframes.html"));
        this.driver.switchTo().frame("iframe1");
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost:3000/formPage.html"));
    }
}

