/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.awt.Dimension;
import java.awt.Point;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.matchers.JUnitMatchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;

public class JavascriptEnabledDriverTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    @Ignore(value="safari", reason="safari: not implemented, ie: fails for some reason.")
    public void testDocumentShouldReflectLatestTitle() throws Exception {
        this.driver.get(this.javascriptPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Testing Javascript"));
        this.driver.findElement(By.linkText((String)"Change the page title!")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Changed"));
        String titleViaXPath = this.driver.findElement(By.xpath((String)"/html/head/title")).getText();
        MatcherAssert.assertThat((Object)titleViaXPath, (Matcher)Matchers.equalTo((Object)"Changed"));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testDocumentShouldReflectLatestDom() throws Exception {
        this.driver.get(this.javascriptPage);
        String currentText = this.driver.findElement(By.xpath((String)"//div[@id='dynamo']")).getText();
        MatcherAssert.assertThat((Object)currentText, (Matcher)Matchers.equalTo((Object)"What's for dinner?"));
        WebElement webElement = this.driver.findElement(By.linkText((String)"Update a div"));
        webElement.click();
        String newText = this.driver.findElement(By.xpath((String)"//div[@id='dynamo']")).getText();
        MatcherAssert.assertThat((Object)newText, (Matcher)Matchers.equalTo((Object)"Fish and chips!"));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldAllowTheUserToTellIfAnElementIsDisplayedOrNot() {
        this.driver.get(this.javascriptPage);
        MatcherAssert.assertThat((Object)((RenderedWebElement)this.driver.findElement(By.id((String)"displayed"))).isDisplayed(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((RenderedWebElement)this.driver.findElement(By.id((String)"none"))).isDisplayed(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)((RenderedWebElement)this.driver.findElement(By.id((String)"hidden"))).isDisplayed(), (Matcher)Is.is((Object)false));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testVisibilityShouldTakeIntoAccountParentVisibility() {
        this.driver.get(this.javascriptPage);
        RenderedWebElement childDiv = (RenderedWebElement)this.driver.findElement(By.id((String)"hiddenchild"));
        RenderedWebElement hiddenLink = (RenderedWebElement)this.driver.findElement(By.id((String)"hiddenlink"));
        JavascriptEnabledDriverTest.assertFalse((boolean)childDiv.isDisplayed());
        JavascriptEnabledDriverTest.assertFalse((boolean)hiddenLink.isDisplayed());
    }

    @JavascriptEnabled
    @Ignore(value="ie, safari", reason="safari: not implemented, ie: Fails")
    public void testShouldWaitForLoadsToCompleteAfterJavascriptCausesANewPageToLoad() {
        this.driver.get(this.formPage);
        this.driver.findElement(By.id((String)"changeme")).setSelected();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Page3"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit")
    public void testShouldBeAbleToDetermineTheLocationOfAnElement() {
        this.driver.get(this.xhtmlTestPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"username"));
        Point location = element.getLocation();
        MatcherAssert.assertThat((Object)(location.getX() > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)(location.getY() > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit")
    public void testShouldBeAbleToDetermineTheSizeOfAnElement() {
        this.driver.get(this.xhtmlTestPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"username"));
        Dimension size = element.getSize();
        MatcherAssert.assertThat((Object)(size.getWidth() > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)(size.getHeight() > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @JavascriptEnabled
    public void testShouldFireOnChangeEventWhenSettingAnElementsValue() {
        this.driver.get(this.javascriptPage);
        this.driver.findElement(By.id((String)"change")).sendKeys(new CharSequence[]{"foo"});
        String result = this.driver.findElement(By.id((String)"result")).getText();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"change"));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToSubmitFormsByCausingTheOnClickEventToFire() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"jsSubmitButton"));
        element.click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.is((Object)"We Arrive Here"));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToClickOnSubmitButtons() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"submittingButton"));
        element.click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.is((Object)"We Arrive Here"));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testIssue80ClickShouldGenerateClickEvent() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"clickField"));
        JavascriptEnabledDriverTest.assertEquals((String)"Hello", (String)element.getValue());
        element.click();
        JavascriptEnabledDriverTest.assertEquals((String)"Clicked", (String)element.getValue());
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit")
    public void testShouldBeAbleToSwitchToFocusedElement() {
        this.driver.get(this.javascriptPage);
        this.driver.findElement(By.id((String)"switchFocus")).click();
        WebElement element = this.driver.switchTo().activeElement();
        MatcherAssert.assertThat((Object)element.getAttribute("id"), (Matcher)Is.is((Object)"theworks"));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testIfNoElementHasFocusTheActiveElementIsTheBody() {
        this.driver.get(this.simpleTestPage);
        WebElement element = this.driver.switchTo().activeElement();
        MatcherAssert.assertThat((Object)element.getAttribute("name"), (Matcher)Is.is((Object)"body"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, firefox, remote, htmlunit", reason="Firefox: Window demands focus to work. Other platforms: not properly tested")
    public void testChangeEventIsFiredAppropriatelyWhenFocusIsLost() {
        this.driver.get(this.javascriptPage);
        WebElement input = this.driver.findElement(By.id((String)"changeable"));
        input.sendKeys(new CharSequence[]{"test"});
        this.driver.findElement(By.id((String)"clickField")).click();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText().trim(), (Matcher)JUnitMatchers.either((Matcher)Is.is((Object)"focus change blur")).or(Is.is((Object)"focus blur change")));
        input.sendKeys(new CharSequence[]{Keys.BACK_SPACE, "t"});
        this.driver.findElement(By.xpath((String)"//body")).click();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText().trim(), (Matcher)JUnitMatchers.either((Matcher)Is.is((Object)"focus change blur focus blur")).or(Is.is((Object)"focus blur change focus blur")).or(Is.is((Object)"focus blur change focus blur change")));
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldBeAbleToClickIfEvenSomethingHorribleHappens() {
        this.driver.get(this.javascriptPage);
        this.driver.findElement(By.id((String)"error")).click();
        String text = this.driver.findElement(By.id((String)"error")).getText();
        JavascriptEnabledDriverTest.assertNotNull((Object)text);
    }

    @JavascriptEnabled
    @Ignore(value="safari")
    public void testShouldNotBeAbleToClickOnAnElementThatIsNotDisplayed() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"unclickable"));
        try {
            element.click();
            JavascriptEnabledDriverTest.fail((String)"You should not be able to click on an invisible element");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit")
    public void testShouldNotBeAbleToToggleAnElementThatIsNotDisplayed() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"untogglable"));
        try {
            element.toggle();
            JavascriptEnabledDriverTest.fail((String)"You should not be able to toggle an invisible element");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit")
    public void testShouldNotBeAbleToSelectAnElementThatIsNotDisplayed() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"untogglable"));
        try {
            element.setSelected();
            JavascriptEnabledDriverTest.fail((String)"You should not be able to select an invisible element");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit")
    public void testShouldNotBeAbleToTypeAnElementThatIsNotDisplayed() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"unclickable"));
        try {
            element.sendKeys(new CharSequence[]{"You don't see me"});
            JavascriptEnabledDriverTest.fail((String)"You should not be able to send keyboard input to an invisible element");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Is.is((Matcher)IsNot.not((Object)"You don't see me")));
    }

    @JavascriptEnabled
    public void testShouldBeAbleToGetTheLocationOfAnElement() {
        this.driver.get(this.javascriptPage);
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        ((JavascriptExecutor)this.driver).executeScript("window.focus();", new Object[0]);
        WebElement element = this.driver.findElement(By.id((String)"keyUp"));
        if (!(element instanceof Locatable)) {
            return;
        }
        Point point = ((Locatable)element).getLocationOnScreenOnceScrolledIntoView();
        JavascriptEnabledDriverTest.assertTrue((point.getX() > 1.0 ? 1 : 0) != 0);
        JavascriptEnabledDriverTest.assertTrue((point.getY() > 1.0 ? 1 : 0) != 0);
    }
}

