/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.environment.GlobalTestEnvironment;

public class PageLoadingTest
extends AbstractDriverTestCase {
    public void testShouldWaitForDocumentToBeLoaded() {
        this.driver.get(this.simpleTestPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Hello WebDriver"));
    }

    public void testShouldFollowRedirectsSentInTheHttpResponseHeaders() {
        this.driver.get(this.redirectPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldFollowMetaRedirects() throws Exception {
        this.driver.get(this.metaRedirectPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldBeAbleToGetAFragmentOnTheCurrentPage() {
        this.driver.get(this.xhtmlTestPage);
        this.driver.get(this.xhtmlTestPage + "#text");
    }

    public void testShouldReturnWhenGettingAUrlThatDoesNotResolve() {
        this.driver.get("http://www.thisurldoesnotexist.comx/");
    }

    public void testShouldReturnWhenGettingAUrlThatDoesNotConnect() {
        this.driver.get("http://localhost:3001");
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToLoadAPageWithFramesetsAndWaitUntilAllFramesAreLoaded() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame(0);
        WebElement pageNumber = this.driver.findElement(By.xpath((String)"//span[@id='pageNumber']"));
        MatcherAssert.assertThat((Object)pageNumber.getText().trim(), (Matcher)Matchers.equalTo((Object)"1"));
        this.driver.switchTo().frame(1);
        pageNumber = this.driver.findElement(By.xpath((String)"//span[@id='pageNumber']"));
        MatcherAssert.assertThat((Object)pageNumber.getText().trim(), (Matcher)Matchers.equalTo((Object)"2"));
    }

    @Ignore(value="safari")
    @NeedsFreshDriver
    public void testSouldDoNothingIfThereIsNothingToGoBackTo() {
        this.driver.get(this.formPage);
        this.driver.navigate().back();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Leave From Here"));
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToNavigateBackInTheBrowserHistory() {
        this.driver.get(this.formPage);
        this.driver.findElement(By.id((String)"imageButton")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
        this.driver.navigate().back();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Leave From Here"));
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToNavigateBackInTheBrowserHistoryInPresenceOfIframes() {
        this.driver.get(this.xhtmlTestPage);
        this.driver.findElement(By.name((String)"sameWindow")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"This page has iframes"));
        this.driver.navigate().back();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToNavigateForwardsInTheBrowserHistory() {
        this.driver.get(this.formPage);
        this.driver.findElement(By.id((String)"imageButton")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
        this.driver.navigate().back();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Leave From Here"));
        this.driver.navigate().forward();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    @Ignore(value="safari, ie, firefox")
    public void testShouldBeAbleToAccessPagesWithAnInsecureSslCertificate() {
        String url = GlobalTestEnvironment.get().getAppServer().whereIsSecure("simpleTest.html");
        this.driver.get(url);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Hello WebDriver"));
    }
}

