/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.DriverTestDecorator;
import org.openqa.selenium.EnvironmentStarter;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.NeedsDriver;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.NoDriverAfterTest;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteBuilder {
    private File baseDir;
    private Set<File> sourceDirs = new HashSet<File>();
    private Set<String> ignored = new HashSet<String>();
    private Class<? extends WebDriver> driverClass;
    private boolean keepDriver;
    private boolean includeJavascript;
    private boolean withDriver = true;
    private boolean withEnvironment = true;
    private String onlyRun;
    private String testMethodName;
    private Set<String> decorators = new LinkedHashSet<String>();

    public TestSuiteBuilder() {
        String[] possiblePaths;
        for (String potential : possiblePaths = new String[]{"common", "../common"}) {
            this.baseDir = new File(potential);
            if (this.baseDir.exists()) break;
        }
        MatcherAssert.assertThat((Object)this.baseDir.exists(), (Matcher)Matchers.is((Object)true));
        this.baseDir = this.baseDir.getParentFile();
        this.exclude("all");
    }

    public TestSuiteBuilder addSourceDir(String dirName) {
        File dir = new File(this.baseDir, dirName + "/test/java");
        if (dir.exists()) {
            this.sourceDirs.add(dir);
        }
        return this;
    }

    public TestSuiteBuilder usingDriver(Class<? extends WebDriver> ss) {
        this.driverClass = ss;
        return this;
    }

    public TestSuiteBuilder usingDriver(String driverClassName) {
        try {
            Class<?> clazz = Class.forName(driverClassName);
            return this.usingDriver(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TestSuiteBuilder exclude(String tagToIgnore) {
        this.ignored.add(tagToIgnore);
        return this;
    }

    public TestSuiteBuilder keepDriverInstance() {
        this.keepDriver = true;
        return this;
    }

    public Test create() throws Exception {
        if (this.withDriver) {
            MatcherAssert.assertThat((String)"No driver class set", this.driverClass, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
        TestSuite suite = new TestSuite();
        for (File dir : this.sourceDirs) {
            this.addTestsRecursively(suite, dir);
        }
        TestSuite toReturn = new TestSuite();
        if (this.withEnvironment) {
            toReturn.addTest((Test)new EnvironmentStarter((Test)suite));
        } else {
            toReturn.addTest((Test)suite);
        }
        if (suite.countTestCases() == 0) {
            System.err.println("No test cases found");
        }
        return this.decorate(toReturn);
    }

    private Test decorate(TestSuite toDecorate) throws Exception {
        TestSuite toReturn = toDecorate;
        for (String name : this.decorators) {
            TestSuite temp = new TestSuite();
            Test test = (Test)Class.forName(name).getConstructor(Test.class).newInstance(toReturn);
            temp.addTest(test);
            toReturn = temp;
        }
        return toReturn;
    }

    private void addTestsRecursively(TestSuite suite, File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.addTestsRecursively(suite, file);
                continue;
            }
            this.addTestsFromFile(suite, file);
        }
    }

    private void addTestsFromFile(TestSuite suite, File file) {
        Method[] methods;
        Class<?> clazz = this.getClassFrom(file);
        if (clazz == null) {
            return;
        }
        int modifiers = clazz.getModifiers();
        if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) {
            return;
        }
        if (this.onlyRun != null && !clazz.getName().endsWith(this.onlyRun)) {
            return;
        }
        for (Method method : methods = clazz.getMethods()) {
            if (!this.isTestMethod(method)) continue;
            Object test = TestSuite.createTest(clazz, (String)method.getName());
            if (test instanceof NeedsDriver) {
                boolean freshDriver = false;
                if (method.isAnnotationPresent(NeedsFreshDriver.class)) {
                    freshDriver = true;
                }
                boolean restartDriver = false;
                if (method.isAnnotationPresent(NoDriverAfterTest.class)) {
                    restartDriver = true;
                }
                if (this.withDriver) {
                    test = new DriverTestDecorator((Test)test, this.driverClass, this.keepDriver, freshDriver, restartDriver);
                }
            }
            suite.addTest(test);
        }
    }

    private boolean isTestMethod(Method method) {
        if (this.testMethodName != null) {
            return method.getName().equals(this.testMethodName);
        }
        if (!method.getName().startsWith("test")) {
            return false;
        }
        if (!this.includeJavascript && method.isAnnotationPresent(JavascriptEnabled.class)) {
            return false;
        }
        Ignore ignore = method.getAnnotation(Ignore.class);
        if (ignore != null) {
            for (String name : this.ignored) {
                if (!ignore.value().contains(name)) continue;
                System.err.println("Ignoring: " + method.getDeclaringClass() + "." + method.getName() + ": " + ignore.reason());
                return false;
            }
        }
        return true;
    }

    private Class<?> getClassFrom(File file) {
        String path = file.getPath().replace('\\', '/');
        if (!path.endsWith(".java")) {
            return null;
        }
        int index = path.indexOf("/org/");
        if (index == -1) {
            return null;
        }
        path = path.substring(index + 1, path.length() - ".java".length());
        path = path.replace("/", ".");
        try {
            return Class.forName(path);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public TestSuiteBuilder includeJavascriptTests() {
        this.includeJavascript = true;
        return this;
    }

    public TestSuiteBuilder usingNoDriver() {
        this.withDriver = false;
        return this;
    }

    public TestSuiteBuilder withoutEnvironment() {
        this.withEnvironment = false;
        return this;
    }

    public TestSuiteBuilder onlyRun(String testCaseName) {
        this.onlyRun = "." + testCaseName;
        return this;
    }

    public TestSuiteBuilder method(String testMethodName) {
        this.testMethodName = testMethodName;
        return this;
    }

    public TestSuiteBuilder addSuiteDecorator(String decoratorClassName) {
        this.decorators.add(decoratorClassName);
        return this;
    }

    public TestSuiteBuilder leaveRunning() {
        System.setProperty("webdriver.singletestsuite.leaverunning", "true");
        return this;
    }
}

