/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebElement;

public class TypingTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    public void testShouldFireKeyPressEvents() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"a"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.containsString((String)"press:"));
    }

    @JavascriptEnabled
    public void testShouldFireKeyDownEvents() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"I"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.containsString((String)"down:"));
    }

    @JavascriptEnabled
    public void testShouldFireKeyUpEvents() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"a"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.containsString((String)"up:"));
    }

    public void testShouldTypeLowerCaseLetters() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"abc def"});
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)"abc def"));
    }

    public void testShouldBeAbleToTypeCapitalLetters() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"ABC DEF"});
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)"ABC DEF"));
    }

    @Ignore(value="safari")
    public void testShouldBeAbleToTypeQuoteMarks() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"\""});
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)"\""));
    }

    public void testShouldBeAbleToTypeTheAtCharacter() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"@"});
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)"@"));
    }

    public void testShouldBeAbleToMixUpperAndLowerCaseLetters() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"me@eXample.com"});
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)"me@eXample.com"));
    }

    @Ignore(value="htmlunit, safari")
    public void testArrowKeysShouldNotBePrintable() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{Keys.ARROW_LEFT});
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)""));
    }

    @Ignore(value="htmlunit, safari")
    public void testShouldBeAbleToUseArrowKeys() {
        this.driver.get(this.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.sendKeys(new CharSequence[]{"Tet", Keys.ARROW_LEFT, "s"});
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)"Test"));
    }

    @JavascriptEnabled
    @Ignore(value="htmlunit")
    public void testWillSimulateAKeyUpWhenEnteringTextIntoInputElements() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyUp"));
        element.sendKeys(new CharSequence[]{"I like cheese"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"I like cheese"));
    }

    @JavascriptEnabled
    public void testWillSimulateAKeyDownWhenEnteringTextIntoInputElements() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyDown"));
        element.sendKeys(new CharSequence[]{"I like cheese"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"I like chees"));
    }

    @JavascriptEnabled
    public void testWillSimulateAKeyPressWhenEnteringTextIntoInputElements() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyPress"));
        element.sendKeys(new CharSequence[]{"I like cheese"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"I like chees"));
    }

    @JavascriptEnabled
    @Ignore(value="htmlunit")
    public void testWillSimulateAKeyUpWhenEnteringTextIntoTextAreas() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyUpArea"));
        element.sendKeys(new CharSequence[]{"I like cheese"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"I like cheese"));
    }

    @JavascriptEnabled
    public void testWillSimulateAKeyDownWhenEnteringTextIntoTextAreas() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyDownArea"));
        element.sendKeys(new CharSequence[]{"I like cheese"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"I like chees"));
    }

    @JavascriptEnabled
    public void testWillSimulateAKeyPressWhenEnteringTextIntoTextAreas() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyPressArea"));
        element.sendKeys(new CharSequence[]{"I like cheese"});
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"I like chees"));
    }

    @JavascriptEnabled
    @Ignore(value="ie, safari, htmlunit, firefox", reason="firefox specific not yet tested in htmlunit. Firefox demands to have the focus on the window already")
    public void testShouldFireFocusKeyEventsInTheRightOrder() {
        this.driver.get(this.javascriptPage);
        WebElement result = this.driver.findElement(By.id((String)"result"));
        WebElement element = this.driver.findElement(By.id((String)"theworks"));
        element.sendKeys(new CharSequence[]{"a"});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.is((Object)"focus keydown keypress keyup"));
    }

    @JavascriptEnabled
    @Ignore(value="ie, safari, htmlunit", reason="firefox-specific")
    public void testShouldReportKeyCodeOfArrowKeys() {
        this.driver.get(this.javascriptPage);
        WebElement result = this.driver.findElement(By.id((String)"result"));
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{Keys.ARROW_DOWN});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.is((Object)"down: 40 press: 40 up: 40"));
        element.sendKeys(new CharSequence[]{Keys.ARROW_UP});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.is((Object)"down: 38 press: 38 up: 38"));
        element.sendKeys(new CharSequence[]{Keys.ARROW_LEFT});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.is((Object)"down: 37 press: 37 up: 37"));
        element.sendKeys(new CharSequence[]{Keys.ARROW_RIGHT});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.is((Object)"down: 39 press: 39 up: 39"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)""));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testShouldReportKeyCodeOfArrowKeysUpDownEvents() {
        this.driver.get(this.javascriptPage);
        WebElement result = this.driver.findElement(By.id((String)"result"));
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{Keys.ARROW_DOWN});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)"down: 40"));
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)"up: 40"));
        element.sendKeys(new CharSequence[]{Keys.ARROW_UP});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)"down: 38"));
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)"up: 38"));
        element.sendKeys(new CharSequence[]{Keys.ARROW_LEFT});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)"down: 37"));
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)"up: 37"));
        element.sendKeys(new CharSequence[]{Keys.ARROW_RIGHT});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)"down: 39"));
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)"up: 39"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)""));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testNumericNonShiftKeys() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        String numericLineCharsNonShifted = "`1234567890-=[]\\;,.'/42";
        element.sendKeys(new CharSequence[]{numericLineCharsNonShifted});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)numericLineCharsNonShifted));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testNumericShiftKeys() {
        this.driver.get(this.javascriptPage);
        WebElement result = this.driver.findElement(By.id((String)"result"));
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        String numericShiftsEtc = "~!@#$%^&*()_+{}:\"<>?|END~";
        element.sendKeys(new CharSequence[]{numericShiftsEtc});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)numericShiftsEtc));
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)" up: 16"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testLowerCaseAlphaKeys() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        String lowerAlphas = "abcdefghijklmnopqrstuvwxyz";
        element.sendKeys(new CharSequence[]{lowerAlphas});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)lowerAlphas));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testUppercaseAlphaKeys() {
        this.driver.get(this.javascriptPage);
        WebElement result = this.driver.findElement(By.id((String)"result"));
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        String upperAlphas = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        element.sendKeys(new CharSequence[]{upperAlphas});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)upperAlphas));
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)" up: 16"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testAllPrintableKeys() {
        this.driver.get(this.javascriptPage);
        WebElement result = this.driver.findElement(By.id((String)"result"));
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        String allPrintable = "!\"#$%&'()*+,-./0123456789:;<=>?@ ABCDEFGHIJKLMNOPQRSTUVWXYZ [\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
        element.sendKeys(new CharSequence[]{allPrintable});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)allPrintable));
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)" up: 16"));
    }

    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testArrowKeysAndPageUpAndDown() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{"a" + Keys.LEFT + "b" + Keys.RIGHT + Keys.UP + Keys.DOWN + Keys.PAGE_UP + Keys.PAGE_DOWN + "1"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"ba1"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testHomeAndEndAndPageUpAndPageDownKeys() {
        if (Platform.getCurrent().is(Platform.MAC)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{"abc" + Keys.HOME + "0" + Keys.LEFT + Keys.RIGHT + Keys.PAGE_UP + Keys.PAGE_DOWN + Keys.END + "1" + Keys.HOME + "0" + Keys.PAGE_UP + Keys.END + "111" + Keys.HOME + "00"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"0000abc1111"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testDeleteAndBackspaceKeys() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{"abcdefghi"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"abcdefghi"));
        element.sendKeys(new CharSequence[]{Keys.LEFT, Keys.LEFT, Keys.DELETE});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"abcdefgi"));
        element.sendKeys(new CharSequence[]{Keys.LEFT, Keys.LEFT, Keys.BACK_SPACE});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"abcdfgi"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testSpecialSpaceKeys() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{"abcd" + Keys.SPACE + "fgh" + Keys.SPACE + "ij"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"abcd fgh ij"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testNumberpadAndFunctionKeys() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{"abcd" + Keys.MULTIPLY + Keys.SUBTRACT + Keys.ADD + Keys.DECIMAL + Keys.SEPARATOR + Keys.NUMPAD0 + Keys.NUMPAD9 + Keys.ADD + Keys.SEMICOLON + Keys.EQUALS + Keys.DIVIDE + Keys.NUMPAD3 + "abcd"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"abcd*-+.,09+;=/3abcd"));
        element.clear();
        element.sendKeys(new CharSequence[]{"FUNCTION" + Keys.F2 + "-KEYS" + Keys.F2});
        element.sendKeys(new CharSequence[]{"" + Keys.F2 + "-TOO" + Keys.F2});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"FUNCTION-KEYS-TOO"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testShiftSelectionDeletes() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{"abcd efgh"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"abcd efgh"));
        element.sendKeys(new CharSequence[]{Keys.SHIFT, Keys.LEFT, Keys.LEFT, Keys.LEFT});
        element.sendKeys(new CharSequence[]{Keys.DELETE});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"abcd e"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testChordControlHomeShiftEndDelete() {
        if (Platform.getCurrent().is(Platform.MAC)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        WebElement result = this.driver.findElement(By.id((String)"result"));
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{"!\"#$%&'()*+,-./0123456789:;<=>?@ ABCDEFG"});
        element.sendKeys(new CharSequence[]{Keys.HOME});
        element.sendKeys(new CharSequence[]{"" + Keys.SHIFT + Keys.END + Keys.DELETE});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.containsString((String)" up: 16"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testChordReveseShiftHomeSelectionDeletes() {
        if (Platform.getCurrent().is(Platform.MAC)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        WebElement result = this.driver.findElement(By.id((String)"result"));
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        element.sendKeys(new CharSequence[]{"done" + Keys.HOME});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"done"));
        element.sendKeys(new CharSequence[]{"" + Keys.SHIFT + "ALL " + Keys.HOME});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"ALL done"));
        element.sendKeys(new CharSequence[]{Keys.DELETE});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"done"));
        element.sendKeys(new CharSequence[]{"" + Keys.END + Keys.SHIFT + Keys.HOME});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"done"));
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)" up: 16"));
        element.sendKeys(new CharSequence[]{"" + Keys.DELETE});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)""));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testChordControlCutAndPaste() {
        if (Platform.getCurrent().is(Platform.MAC)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"keyReporter"));
        WebElement result = this.driver.findElement(By.id((String)"result"));
        String paste = "!\"#$%&'()*+,-./0123456789:;<=>?@ ABCDEFG";
        element.sendKeys(new CharSequence[]{paste});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)paste));
        element.sendKeys(new CharSequence[]{"" + Keys.HOME + Keys.SHIFT + Keys.END});
        MatcherAssert.assertThat((Object)result.getText().trim(), (Matcher)Matchers.containsString((String)" up: 16"));
        element.sendKeys(new CharSequence[]{Keys.CONTROL, "x"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)""));
        element.sendKeys(new CharSequence[]{Keys.CONTROL, "v"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)paste));
        element.sendKeys(new CharSequence[]{"" + Keys.LEFT + Keys.LEFT + Keys.LEFT + Keys.SHIFT + Keys.END});
        element.sendKeys(new CharSequence[]{Keys.CONTROL, "xv"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)paste));
        element.sendKeys(new CharSequence[]{Keys.HOME});
        element.sendKeys(new CharSequence[]{Keys.CONTROL, "v"});
        element.sendKeys(new CharSequence[]{Keys.CONTROL, "vv"});
        element.sendKeys(new CharSequence[]{Keys.CONTROL, "vvv"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)("EFGEFGEFGEFGEFGEFG" + paste)));
        element.sendKeys(new CharSequence[]{"" + Keys.END + Keys.SHIFT + Keys.HOME + Keys.NULL + Keys.DELETE});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)""));
    }

    @JavascriptEnabled
    public void testShouldTypeIntoInputElementsThatHaveNoTypeAttribute() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.id((String)"no-type"));
        element.sendKeys(new CharSequence[]{"Should Say Cheese"});
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"Should Say Cheese"));
    }

    @JavascriptEnabled
    @Ignore(value="safari, htmlunit", reason="untested user agents")
    public void testShouldNotTypeIntoElementsThatPreventKeyDownEvents() {
        this.driver.get(this.javascriptPage);
        WebElement silent = this.driver.findElement(By.name((String)"suppress"));
        silent.sendKeys(new CharSequence[]{"s"});
        MatcherAssert.assertThat((Object)silent.getValue(), (Matcher)Matchers.is((Object)""));
    }

    @JavascriptEnabled
    @Ignore(value="ie, safari, htmlunit", reason="firefox-specific")
    public void testGenerateKeyPressEventEvenWhenElementPreventsDefault() {
        this.driver.get(this.javascriptPage);
        WebElement silent = this.driver.findElement(By.name((String)"suppress"));
        WebElement result = this.driver.findElement(By.id((String)"result"));
        silent.sendKeys(new CharSequence[]{"s"});
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.containsString((String)"press"));
    }
}

