/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.NoDriverAfterTest;
import org.openqa.selenium.NoSuchWindowException;

public class WindowSwitchingTest
extends AbstractDriverTestCase {
    @Ignore(value="ie, remote, safari")
    public void testShouldSwitchFocusToANewWindowWhenItIsOpenedAndNotStopFutureOperations() {
        this.driver.get(this.xhtmlTestPage);
        this.driver.findElement(By.linkText((String)"Open new window")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
        this.driver.switchTo().window("result");
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
        this.driver.get(this.iframePage);
        this.driver.findElement(By.id((String)"iframe_page_heading"));
    }

    @Ignore(value="ie, remote, safari")
    public void testShouldThrowNoSuchWindowException() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.switchTo().window("invalid name");
            WindowSwitchingTest.fail((String)"NoSuchWindowException expected");
        }
        catch (NoSuchWindowException noSuchWindowException) {
            // empty catch block
        }
    }

    @NeedsFreshDriver
    @NoDriverAfterTest
    @Ignore(value="ie, remote, safari")
    public void testShouldBeAbleToIterateOverAllOpenWindows() throws Exception {
        this.driver.get(this.xhtmlTestPage);
        this.driver.findElement(By.name((String)"windowOne")).click();
        this.driver.findElement(By.name((String)"windowTwo")).click();
        Thread.sleep(500L);
        Iterator allWindows = this.driver.switchTo().windowIterable().iterator();
        allWindows.next();
        allWindows.next();
        allWindows.next();
        WindowSwitchingTest.assertFalse((boolean)allWindows.hasNext());
    }

    public void testRemovingDriversFromTheWindowIteratorShouldCloseTheUnderlyingWindow() {
    }
}

