/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class XPathElementFindingTest
extends AbstractDriverTestCase {
    public void testShouldThrowAnExceptionWhenThereIsNoLinkToClickAndItIsFoundWithXPath() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.findElement(By.xpath((String)"//a[@id='Not here']"));
            XPathElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldThrowAnExceptionWhenThereIsNoLinkToClick() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.findElement(By.xpath((String)"//a[@id='Not here']"));
            XPathElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldFindSingleElementByXPath() {
        this.driver.get(this.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.xpath((String)"//h1"));
        MatcherAssert.assertThat((Object)element.getText(), (Matcher)Matchers.equalTo((Object)"XHTML Might Be The Future"));
    }

    @Ignore(value="safari", reason="Test fails")
    public void testShouldFindElementsByXPath() {
        this.driver.get(this.xhtmlTestPage);
        List divs = this.driver.findElements(By.xpath((String)"//div"));
        MatcherAssert.assertThat((Object)divs.size(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Ignore(value="safari", reason="Test fails")
    public void testShouldBeAbleToFindManyElementsRepeatedlyByXPath() {
        this.driver.get(this.xhtmlTestPage);
        String xpathString = "//node()[contains(@id,'id')]";
        MatcherAssert.assertThat((Object)this.driver.findElements(By.xpath((String)xpathString)).size(), (Matcher)Matchers.equalTo((Object)3));
        xpathString = "//node()[contains(@id,'nope')]";
        MatcherAssert.assertThat((Object)this.driver.findElements(By.xpath((String)xpathString)).size(), (Matcher)Matchers.equalTo((Object)0));
    }

    public void testShouldBeAbleToIdentifyElementsByClass() {
        this.driver.get(this.xhtmlTestPage);
        String header = this.driver.findElement(By.xpath((String)"//h1[@class='header']")).getText();
        MatcherAssert.assertThat((Object)header, (Matcher)Matchers.equalTo((Object)"XHTML Might Be The Future"));
    }

    public void testShouldBeAbleToSearchForMultipleAttributes() {
        this.driver.get(this.formPage);
        try {
            this.driver.findElement(By.xpath((String)"//form[@name='optional']/input[@type='submit' and @value='Click!']")).click();
        }
        catch (NoSuchElementException e) {
            XPathElementFindingTest.fail((String)"Should be able to find the submit button");
        }
    }

    public void testShouldLocateElementsWithGivenText() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.findElement(By.xpath((String)"//a[text()='click me']"));
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            XPathElementFindingTest.fail((String)"Cannot find the element");
        }
    }
}

