/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.environment.webserver;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Servlet;
import junit.framework.Assert;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.openqa.selenium.environment.webserver.AppServer;
import org.openqa.selenium.environment.webserver.PageServlet;
import org.openqa.selenium.environment.webserver.RedirectServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetty6AppServer
implements AppServer {
    private int port;
    private int securePort;
    private File path;
    private final Server server = new Server();
    private WebAppContext context;

    public Jetty6AppServer() {
        this.path = this.findRootOfWebApp();
        this.context = this.addWebApplication("", this.path.getAbsolutePath());
        this.addServlet("Redirecter", "/redirect", RedirectServlet.class);
        this.addServlet("InfinitePagerServer", "/page/*", PageServlet.class);
        this.listenOn(3000);
        this.listenSecurelyOn(3443);
    }

    protected File findRootOfWebApp() {
        String[] possiblePaths;
        for (String potential : possiblePaths = new String[]{"common/src/web", "../common/src/web"}) {
            File current = new File(potential);
            if (!current.exists()) continue;
            return current;
        }
        Assert.assertTrue((String)"Unable to find common web files. These are located in the common directory", (boolean)this.path.exists());
        return null;
    }

    @Override
    public String getHostName() {
        return "localhost";
    }

    @Override
    public String getAlternateHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String whereIs(String relativeUrl) {
        return "http://" + this.getHostName() + ":" + this.port + "/" + relativeUrl;
    }

    @Override
    public String whereElseIs(String relativeUrl) {
        return "http://" + this.getAlternateHostName() + ":" + this.port + "/" + relativeUrl;
    }

    @Override
    public String whereIsSecure(String relativeUrl) {
        return "https://" + this.getHostName() + ":" + this.securePort + "/" + relativeUrl;
    }

    @Override
    public void start() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        File keyStore = this.getKeyStore();
        if (!keyStore.exists()) {
            throw new RuntimeException("Cannot find keystore for SSL cert: " + keyStore.getAbsolutePath());
        }
        SslSocketConnector secureSocket = new SslSocketConnector();
        secureSocket.setPort(this.securePort);
        secureSocket.setKeystore(keyStore.getAbsolutePath());
        secureSocket.setPassword("password");
        secureSocket.setKeyPassword("password");
        secureSocket.setTruststore(keyStore.getAbsolutePath());
        secureSocket.setTrustPassword("password");
        this.server.addConnector((Connector)secureSocket);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected File getKeyStore() {
        return new File(this.findRootOfWebApp(), "../../test/java/keystore");
    }

    @Override
    public void listenOn(int port) {
        this.port = port;
    }

    @Override
    public void listenSecurelyOn(int port) {
        this.securePort = port;
    }

    protected void addListener(Connector listener) {
        this.server.addConnector(listener);
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addServlet(String name, String url, Class<? extends Servlet> servletClass) {
        try {
            this.context.addServlet(servletClass, url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addAdditionalWebApplication(String context, String absolutePath) {
        this.addWebApplication(context, absolutePath);
    }

    private WebAppContext addWebApplication(String contextPath, String absolutePath) {
        WebAppContext app = new WebAppContext();
        app.setContextPath(contextPath);
        app.setWar(absolutePath);
        this.server.addHandler((Handler)app);
        return app;
    }
}

