/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxWebElement
implements RenderedWebElement,
Locatable,
FindsByXPath,
FindsByLinkText,
FindsById,
FindsByName,
FindsByClassName,
SearchContext {
    private final FirefoxDriver parent;
    private final String elementId;

    public FirefoxWebElement(FirefoxDriver parent, String elementId) {
        this.parent = parent;
        this.elementId = elementId;
    }

    public void click() {
        this.sendMessage(UnsupportedOperationException.class, "click", new Object[0]);
    }

    public void submit() {
        this.sendMessage(RuntimeException.class, "submitElement", new Object[0]);
    }

    public String getValue() {
        try {
            String toReturn = this.sendMessage(RuntimeException.class, "getElementValue", new Object[0]);
            return toReturn.replace("\n", Platform.getCurrent().getLineEnding());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public void clear() {
        this.sendMessage(UnsupportedOperationException.class, "clear", new Object[0]);
    }

    public void sendKeys(CharSequence ... value) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : value) {
            builder.append(seq);
        }
        this.sendMessage(UnsupportedOperationException.class, "sendKeys", builder.toString());
    }

    public String getElementName() {
        String name = this.sendMessage(RuntimeException.class, "getElementName", new Object[0]);
        return name;
    }

    public String getAttribute(String name) {
        try {
            return this.sendMessage(RuntimeException.class, "getElementAttribute", name);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public boolean toggle() {
        this.sendMessage(UnsupportedOperationException.class, "toggleElement", new Object[0]);
        return this.isSelected();
    }

    public boolean isSelected() {
        String value = this.sendMessage(RuntimeException.class, "getElementSelected", new Object[0]);
        return Boolean.parseBoolean(value);
    }

    public void setSelected() {
        this.sendMessage(UnsupportedOperationException.class, "setElementSelected", new Object[0]);
    }

    public boolean isEnabled() {
        String value = this.getAttribute("disabled");
        return !Boolean.parseBoolean(value);
    }

    public String getText() {
        String toReturn = this.sendMessage(RuntimeException.class, "getElementText", new Object[0]);
        return toReturn.replace("\n", Platform.getCurrent().getLineEnding());
    }

    public List<WebElement> getChildrenOfType(String tagName) {
        String response = this.sendMessage(RuntimeException.class, "getElementChildren", tagName);
        String[] ids = response.split(" ");
        ArrayList<WebElement> children = new ArrayList<WebElement>();
        for (String id : ids) {
            children.add((WebElement)new FirefoxWebElement(this.parent, id));
        }
        return children;
    }

    public boolean isDisplayed() {
        return Boolean.parseBoolean(this.sendMessage(RuntimeException.class, "isElementDisplayed", new Object[0]));
    }

    public Point getLocation() {
        String result = this.sendMessage(RuntimeException.class, "getElementLocation", new Object[0]);
        String[] parts = result.split(",");
        int x = Integer.parseInt(parts[0].trim());
        int y = Integer.parseInt(parts[1].trim());
        return new Point(x, y);
    }

    public Dimension getSize() {
        String result = this.sendMessage(RuntimeException.class, "getElementSize", new Object[0]);
        String[] parts = result.split(",");
        int x = Integer.parseInt(parts[0].trim());
        int y = Integer.parseInt(parts[1].trim());
        return new Dimension(x, y);
    }

    public void dragAndDropBy(int moveRight, int moveDown) {
        this.sendMessage(UnsupportedOperationException.class, "dragAndDrop", moveRight, moveDown);
    }

    public void dragAndDropOn(RenderedWebElement element) {
        Point currentLocation = this.getLocation();
        Point destination = element.getLocation();
        this.dragAndDropBy(destination.x - currentLocation.x, destination.y - currentLocation.y);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElementByXPath(String xpath) {
        List<WebElement> elements = this.findElementsByXPath(xpath);
        if (elements.size() == 0) {
            throw new NoSuchElementException("Unable to find element with xpath " + xpath);
        }
        return elements.get(0);
    }

    public List<WebElement> findElementsByXPath(String xpath) {
        String indices = this.sendMessage(RuntimeException.class, "findElementsByXPath", xpath);
        return this.getElementsFromIndices(indices);
    }

    public WebElement findElementByLinkText(String linkText) {
        List<WebElement> elements = this.findElementsByLinkText(linkText);
        if (elements.size() == 0) {
            throw new NoSuchElementException("Unable to find element with linkText" + linkText);
        }
        return elements.get(0);
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        String indices = this.sendMessage(RuntimeException.class, "findElementsByLinkText", linkText);
        return this.getElementsFromIndices(indices);
    }

    public WebElement findElementByPartialLinkText(String using) {
        String id = this.sendMessage(RuntimeException.class, "findElementByPartialLinkText", using);
        return new FirefoxWebElement(this.parent, id);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        String indices = this.sendMessage(RuntimeException.class, "findElementsByPartialLinkText", using);
        return this.getElementsFromIndices(indices);
    }

    private List<WebElement> getElementsFromIndices(String indices) {
        String[] ids;
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (indices.length() == 0) {
            return elements;
        }
        for (String id : ids = indices.split(",")) {
            elements.add((WebElement)new FirefoxWebElement(this.parent, id));
        }
        return elements;
    }

    public WebElement findElementById(String id) {
        String response = this.sendMessage(RuntimeException.class, "findElementById", id);
        if (response.equals("-1")) {
            throw new NoSuchElementException("Unable to find element with id" + id);
        }
        return new FirefoxWebElement(this.parent, response);
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElementsByXPath(".//*[@id = '" + id + "']");
    }

    public WebElement findElementByName(String name) {
        return this.findElementByXPath(".//*[@name = '" + name + "']");
    }

    public List<WebElement> findElementsByName(String name) {
        return this.findElementsByXPath(".//*[@name = '" + name + "']");
    }

    public WebElement findElementByClassName(String using) {
        List<WebElement> elements = this.findElementsByClassName(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("Unable to find element by class name " + using);
        }
        return elements.get(0);
    }

    public List<WebElement> findElementsByClassName(String using) {
        String indices = this.sendMessage(RuntimeException.class, "findChildElementsByClassName", using);
        return this.getElementsFromIndices(indices);
    }

    public String getValueOfCssProperty(String propertyName) {
        return this.sendMessage(RuntimeException.class, "getElementCssProperty", propertyName);
    }

    private String sendMessage(Class<? extends RuntimeException> throwOnFailure, String methodName, Object ... parameters) {
        return this.parent.sendMessage(throwOnFailure, new Command(this.parent.context, this.elementId, methodName, parameters));
    }

    public String getElementId() {
        return this.elementId;
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        String json = this.sendMessage(RuntimeException.class, "getLocationOnceScrolledIntoView", new Object[0]);
        if (json == null) {
            return null;
        }
        try {
            JSONObject mapped = new JSONObject(json);
            return new Point(mapped.getInt("x"), mapped.getInt("y"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

