/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByXPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUnitWebElement
implements WebElement,
FindsById,
FindsByLinkText,
FindsByXPath,
FindsByName,
SearchContext {
    protected final HtmlUnitDriver parent;
    protected final HtmlElement element;
    private static final char nbspChar = '\u00a0';
    private static final String[] blockLevelsTagNames = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "dl", "div", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address", "ul", "ol", "pre", "br"};

    public HtmlUnitWebElement(HtmlUnitDriver parent, HtmlElement element) {
        this.parent = parent;
        this.element = element;
    }

    public void click() {
        if (!(this.element instanceof ClickableElement)) {
            return;
        }
        ClickableElement clickableElement = (ClickableElement)this.element;
        try {
            if (this.parent.isJavascriptEnabled() && !(this.element instanceof HtmlInput)) {
                this.element.focus();
            }
            clickableElement.click();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
    }

    public void submit() {
        try {
            if (this.element instanceof HtmlForm) {
                this.submitForm((HtmlForm)this.element);
                return;
            }
            if (this.element instanceof HtmlSubmitInput) {
                ((HtmlSubmitInput)this.element).click();
                return;
            }
            if (this.element instanceof HtmlImageInput) {
                ((HtmlImageInput)this.element).click();
                return;
            }
            if (this.element instanceof HtmlInput) {
                this.submitForm(this.element.getEnclosingForm());
                return;
            }
            WebElement form = this.findParentForm();
            if (form == null) {
                throw new NoSuchElementException("Unable to find the containing form");
            }
            form.submit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void submitForm(HtmlForm form) {
        ArrayList<String> names = new ArrayList<String>();
        names.add("input");
        names.add("button");
        List allElements = form.getHtmlElementsByTagNames(names);
        HtmlElement submit = null;
        for (HtmlElement element : allElements) {
            if (!this.isSubmitElement(element) || !this.isBefore(submit, element)) continue;
            submit = element;
        }
        if (submit == null) {
            throw new RuntimeException("Cannot locate element used to submit form");
        }
        try {
            ((ClickableElement)submit).click();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSubmitElement(HtmlElement element) {
        HtmlButton button;
        HtmlElement candidate = null;
        if (element instanceof HtmlSubmitInput && !((HtmlSubmitInput)element).isDisabled()) {
            candidate = element;
        } else if (element instanceof HtmlImageInput && !((HtmlImageInput)element).isDisabled()) {
            candidate = element;
        } else if (element instanceof HtmlButton && "submit".equalsIgnoreCase((button = (HtmlButton)element).getTypeAttribute()) && !button.isDisabled()) {
            candidate = element;
        }
        return candidate != null;
    }

    private boolean isBefore(HtmlElement submit, HtmlElement element) {
        return submit == null;
    }

    public String getValue() {
        if (this.element instanceof HtmlTextArea) {
            return ((HtmlTextArea)this.element).getText();
        }
        return this.getAttribute("value");
    }

    public void clear() {
        if (this.element instanceof HtmlInput) {
            this.element.setAttributeValue("value", "");
        } else if (this.element instanceof HtmlTextArea) {
            ((HtmlTextArea)this.element).setText("");
        }
    }

    public void sendKeys(CharSequence ... value) {
        String currentValue;
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : value) {
            builder.append(seq);
        }
        if (this.parent.isJavascriptEnabled() && !(this.element instanceof HtmlFileInput)) {
            try {
                this.element.type(builder.toString());
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.element instanceof HtmlInput) {
            currentValue = this.getValue();
            this.element.setAttributeValue("value", (currentValue == null ? "" : currentValue) + builder.toString());
        } else if (this.element instanceof HtmlTextArea) {
            currentValue = this.getValue();
            ((HtmlTextArea)this.element).setText((currentValue == null ? "" : currentValue) + builder.toString());
        } else {
            throw new UnsupportedOperationException("You may only set the value of elements that are input elements");
        }
    }

    public String getElementName() {
        return this.element.getNodeName();
    }

    public String getAttribute(String name) {
        String lowerName = name.toLowerCase();
        String value = this.element.getAttributeValue(name);
        if ("disabled".equals(lowerName)) {
            return this.isEnabled() ? "false" : "true";
        }
        if ("selected".equals(lowerName)) {
            return value.equalsIgnoreCase("selected") ? "true" : "false";
        }
        if ("checked".equals(lowerName)) {
            return value.equalsIgnoreCase("checked") ? "true" : "false";
        }
        if (!"".equals(value)) {
            return value;
        }
        if (this.element.isAttributeDefined(name)) {
            return "";
        }
        return null;
    }

    public boolean toggle() {
        try {
            HtmlOption option;
            HtmlSelect select;
            if (this.element instanceof HtmlCheckBoxInput) {
                ((HtmlCheckBoxInput)this.element).click();
                return this.isSelected();
            }
            if (this.element instanceof HtmlOption && (select = (option = (HtmlOption)this.element).getEnclosingSelect()).isMultipleSelectEnabled()) {
                option.setSelected(!option.isSelected());
                return this.isSelected();
            }
            throw new UnsupportedOperationException("You may only toggle checkboxes or options in a select which allows multiple selections");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception: " + e);
        }
    }

    public boolean isSelected() {
        if (this.element instanceof HtmlInput) {
            return ((HtmlInput)this.element).isChecked();
        }
        if (this.element instanceof HtmlOption) {
            return ((HtmlOption)this.element).isSelected();
        }
        throw new UnsupportedOperationException("Unable to determine if element is selected. Tag name is: " + this.element.getTagName());
    }

    public void setSelected() {
        String disabledValue = this.element.getAttributeValue("disabled");
        if (disabledValue.length() > 0) {
            throw new UnsupportedOperationException("You may not select a disabled element");
        }
        if (this.element instanceof HtmlInput) {
            ((HtmlInput)this.element).setChecked(true);
        } else if (this.element instanceof HtmlOption) {
            ((HtmlOption)this.element).setSelected(true);
        } else {
            throw new UnsupportedOperationException("Unable to select element. Tag name is: " + this.element.getTagName());
        }
    }

    public boolean isEnabled() {
        if (this.element instanceof HtmlInput) {
            return !((HtmlInput)this.element).isDisabled();
        }
        if (this.element instanceof HtmlTextArea) {
            return !((HtmlTextArea)this.element).isDisabled();
        }
        return true;
    }

    public String getText() {
        int index;
        StringBuffer toReturn = new StringBuffer();
        StringBuffer textSoFar = new StringBuffer();
        this.getTextFromNode((DomNode)this.element, toReturn, textSoFar, this.element instanceof HtmlPreformattedText);
        String text = toReturn.toString() + this.collapseWhitespace(textSoFar);
        for (index = text.length(); index > 0 && this.isWhiteSpace(text.charAt(index - 1)); --index) {
        }
        return text.substring(0, index);
    }

    protected HtmlUnitDriver getParent() {
        return this.parent;
    }

    protected HtmlElement getElement() {
        return this.element;
    }

    private boolean isWhiteSpace(int lastChar) {
        return lastChar == 10 || lastChar == 32 || lastChar == 9 || lastChar == 13;
    }

    private void getTextFromNode(DomNode node, StringBuffer toReturn, StringBuffer textSoFar, boolean isPreformatted) {
        if (isPreformatted) {
            this.getPreformattedText(node, toReturn);
        }
        for (DomNode child : node.getChildren()) {
            if (child instanceof HtmlPreformattedText) {
                toReturn.append(this.collapseWhitespace(textSoFar));
                textSoFar.delete(0, textSoFar.length());
                this.getTextFromNode(child, toReturn, textSoFar, true);
                continue;
            }
            if (child instanceof DomText) {
                String textToAdd = ((DomText)child).getData();
                textToAdd = textToAdd.replace('\u00a0', ' ');
                textSoFar.append(textToAdd);
                continue;
            }
            this.getTextFromNode(child, toReturn, textSoFar, false);
        }
        if (this.isBlockLevel(node)) {
            toReturn.append(this.collapseWhitespace(textSoFar)).append(Platform.getCurrent().getLineEnding());
            textSoFar.delete(0, textSoFar.length());
        }
    }

    private boolean isBlockLevel(DomNode node) {
        if (!(node instanceof HtmlElement)) {
            return false;
        }
        String tagName = ((HtmlElement)node).getTagName().toLowerCase();
        for (String blockLevelsTagName : blockLevelsTagNames) {
            if (!blockLevelsTagName.equals(tagName)) continue;
            return true;
        }
        return false;
    }

    private String collapseWhitespace(StringBuffer textSoFar) {
        String textToAdd = textSoFar.toString();
        return textToAdd.replaceAll("\\p{javaWhitespace}+", " ").replaceAll("\r", "");
    }

    private void getPreformattedText(DomNode node, StringBuffer toReturn) {
        String xmlText = node.asXml();
        toReturn.append(xmlText.replaceAll("^<pre.*?>", "").replaceAll("</pre.*>$", ""));
    }

    public List<WebElement> getChildrenOfType(String tagName) {
        Iterable allChildren = this.element.getAllHtmlChildElements();
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (HtmlElement child : allChildren) {
            if (!tagName.equals(child.getTagName())) continue;
            elements.add(this.getParent().newHtmlUnitWebElement(child));
        }
        return elements;
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElementById(String id) {
        return this.findElementByXPath(".//*[@id = '" + id + "']");
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElementsByXPath(".//*[@id = '" + id + "']");
    }

    public WebElement findElementByXPath(String xpathExpr) {
        HtmlElement match = (HtmlElement)this.element.getFirstByXPath(xpathExpr);
        if (match == null) {
            throw new NoSuchElementException("Unable to find element with xpath " + xpathExpr);
        }
        return this.getParent().newHtmlUnitWebElement(match);
    }

    public List<WebElement> findElementsByXPath(String xpathExpr) {
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        List htmlElements = this.element.getByXPath(xpathExpr);
        for (Object e : htmlElements) {
            webElements.add(this.getParent().newHtmlUnitWebElement((HtmlElement)e));
        }
        return webElements;
    }

    public WebElement findElementByLinkText(String linkText) {
        List<WebElement> elements = this.findElementsByLinkText(linkText);
        if (elements.size() == 0) {
            throw new NoSuchElementException("Unable to find element with linkText " + linkText);
        }
        return elements.size() > 0 ? elements.get(0) : null;
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        List htmlElements = this.element.getHtmlElementsByTagName("a");
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        for (HtmlElement e : htmlElements) {
            if (!e.getTextContent().equals(linkText) || e.getAttribute("href") == null) continue;
            webElements.add(this.getParent().newHtmlUnitWebElement(e));
        }
        return webElements;
    }

    public WebElement findElementByPartialLinkText(String linkText) {
        List<WebElement> elements = this.findElementsByPartialLinkText(linkText);
        if (elements.size() == 0) {
            throw new NoSuchElementException("Unable to find element with linkText " + linkText);
        }
        return elements.size() > 0 ? elements.get(0) : null;
    }

    public List<WebElement> findElementsByPartialLinkText(String linkText) {
        List htmlElements = this.element.getHtmlElementsByTagName("a");
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        for (HtmlElement e : htmlElements) {
            if (!e.getTextContent().contains(linkText) || e.getAttribute("href") == null) continue;
            webElements.add(this.getParent().newHtmlUnitWebElement(e));
        }
        return webElements;
    }

    public WebElement findElementByName(String name) {
        return this.findElementByXPath(".//*[@name = '" + name + "']");
    }

    public List<WebElement> findElementsByName(String name) {
        return this.findElementsByXPath(".//*[@name = '" + name + "']");
    }

    private WebElement findParentForm() {
        HtmlElement current;
        for (current = this.element; current != null && !(current instanceof HtmlForm); current = current.getParentNode()) {
        }
        return this.getParent().newHtmlUnitWebElement((HtmlElement)((HtmlForm)current));
    }
}

