/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.Finder;
import org.openqa.selenium.internal.Locatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetExplorerElement
implements RenderedWebElement,
SearchContext,
Locatable {
    private long nodePointer;

    private InternetExplorerElement(long nodePointer) {
        this.nodePointer = nodePointer;
    }

    public native void click();

    public native String getElementName();

    public native String getAttribute(String var1);

    public List<WebElement> getChildrenOfType(String tagName) {
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        this.getChildrenOfTypeNatively(toReturn, tagName);
        return toReturn;
    }

    public native String getText();

    public native String getValue();

    public void sendKeys(CharSequence ... value) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : value) {
            builder.append(seq);
        }
        this.doSendKeys(builder.toString());
    }

    private native void doSendKeys(String var1);

    public native void clear();

    public native boolean isEnabled();

    public native boolean isSelected();

    public native void setSelected();

    public native void submit();

    public native boolean toggle();

    public native boolean isDisplayed();

    public native Point getLocationOnScreenOnceScrolledIntoView();

    public native Point getLocation();

    public native Dimension getSize();

    public native String getValueOfCssProperty(String var1);

    private native long getElementNode();

    private native void releaseElementNode(long var1);

    private native long getIePointer();

    private native void releaseIePointer(long var1);

    protected void finalize() throws Throwable {
        this.deleteStoredObject();
    }

    private native void deleteStoredObject();

    private native void getChildrenOfTypeNatively(List<WebElement> var1, String var2);

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        throw new UnsupportedOperationException();
    }

    public void dragAndDropOn(RenderedWebElement element) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElement(By by) {
        long node = this.getElementNode();
        long iePointer = this.getIePointer();
        try {
            WebElement webElement = new Finder(iePointer, node).findElement(by);
            return webElement;
        }
        finally {
            this.releaseIePointer(iePointer);
            this.releaseElementNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElements(By by) {
        long node = this.getElementNode();
        long iePointer = this.getIePointer();
        try {
            List<WebElement> list = new Finder(iePointer, node).findElements(by);
            return list;
        }
        finally {
            this.releaseIePointer(iePointer);
            this.releaseElementNode(node);
        }
    }
}

