/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.lift;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.lift.TestContext;
import org.openqa.selenium.lift.find.Finder;
import org.openqa.selenium.lift.match.NumericalMatchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverTestContext
implements TestContext {
    private WebDriver driver;

    public WebDriverTestContext(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public void goTo(String url) {
        this.driver.get(url);
    }

    @Override
    public void assertPresenceOf(Finder<WebElement, WebDriver> finder) {
        this.assertPresenceOf(NumericalMatchers.atLeast(1), finder);
    }

    @Override
    public void assertPresenceOf(Matcher<Integer> cardinalityConstraint, Finder<WebElement, WebDriver> finder) {
        Collection<WebElement> foundElements = finder.findFrom(this.driver);
        if (!cardinalityConstraint.matches((Object)foundElements.size())) {
            StringDescription description = new StringDescription();
            description.appendText("\nExpected: ").appendDescriptionOf(cardinalityConstraint).appendText(" ").appendDescriptionOf(finder).appendText("\n     got: ").appendValue((Object)foundElements.size()).appendText(" ").appendDescriptionOf(finder).appendText("\n");
            this.failWith(description.toString());
        }
    }

    @Override
    public void type(String input, Finder<WebElement, WebDriver> finder) {
        WebElement element = this.findOneElementTo("type into", finder);
        element.sendKeys(new CharSequence[]{input});
    }

    @Override
    public void clickOn(Finder<WebElement, WebDriver> finder) {
        WebElement element = this.findOneElementTo("click on", finder);
        element.click();
    }

    private WebElement findOneElementTo(String action, Finder<WebElement, WebDriver> finder) {
        Collection<WebElement> foundElements = finder.findFrom(this.driver);
        if (foundElements.isEmpty()) {
            this.failWith("could not find element to " + action);
        } else if (foundElements.size() > 1) {
            this.failWith("did not know what to " + action + " - ambiguous");
        }
        return foundElements.iterator().next();
    }

    private void failWith(String message) throws AssertionError {
        throw new AssertionError((Object)message);
    }
}

