/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.lift.find;

import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.openqa.selenium.lift.find.Finder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFinder<S, T>
implements Finder<S, T> {
    protected Matcher<S> matcher;

    @Override
    public Collection<S> findFrom(T context) {
        Collection<S> found = this.extractFrom(context);
        if (this.matcher == null) {
            return found;
        }
        return this.allMatching(this.matcher, found);
    }

    @Override
    public Finder<S, T> with(Matcher<S> matcher) {
        this.matcher = matcher;
        return this;
    }

    public void describeTo(Description description) {
        this.describeTargetTo(description);
        if (this.matcher != null) {
            description.appendText(" with ");
            this.matcher.describeTo(description);
        }
    }

    protected abstract Collection<S> extractFrom(T var1);

    protected abstract void describeTargetTo(Description var1);

    protected Collection<S> allMatching(Matcher<?> matcher, Collection<S> items) {
        ArrayList<S> temp = new ArrayList<S>();
        for (S item : items) {
            if (!matcher.matches(item)) continue;
            temp.add(item);
        }
        return temp;
    }
}

