/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.internal.LocatingElementHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFactory {
    public static <T> T initElements(WebDriver driver, Class<T> pageClassToProxy) {
        T page = PageFactory.instantiatePage(driver, pageClassToProxy);
        PageFactory.initElements(driver, page);
        return page;
    }

    public static void initElements(WebDriver driver, Object page) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            PageFactory.proxyFields(driver, page, proxyIn);
        }
    }

    private static void proxyFields(WebDriver driver, Object page, Class<?> proxyIn) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            if (!WebElement.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            PageFactory.proxyElement(driver, page, field);
        }
    }

    private static void proxyElement(WebDriver driver, Object page, Field field) {
        LocatingElementHandler handler = new LocatingElementHandler(driver, field);
        Object proxy = field.getType().equals(RenderedWebElement.class) ? (RenderedWebElement)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{RenderedWebElement.class}, (InvocationHandler)handler) : (WebElement)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{WebElement.class}, (InvocationHandler)handler);
        try {
            field.set(page, proxy);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T instantiatePage(WebDriver driver, Class<T> pageClassToProxy) {
        try {
            try {
                Constructor<T> constructor = pageClassToProxy.getConstructor(WebDriver.class);
                return constructor.newInstance(driver);
            }
            catch (NoSuchMethodException e) {
                return pageClassToProxy.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

