/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.events;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventFiringWebDriver
implements WebDriver,
JavascriptExecutor {
    private final WebDriver driver;
    private final List<WebDriverEventListener> eventListeners = new ArrayList<WebDriverEventListener>();
    private final WebDriverEventListener dispatcher = (WebDriverEventListener)Proxy.newProxyInstance(WebDriverEventListener.class.getClassLoader(), new Class[]{WebDriverEventListener.class}, new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (WebDriverEventListener eventListener : EventFiringWebDriver.this.eventListeners) {
                method.invoke((Object)eventListener, args);
            }
            return null;
        }
    });

    public EventFiringWebDriver(WebDriver driver) {
        this.driver = driver;
    }

    public EventFiringWebDriver register(WebDriverEventListener eventListener) {
        this.eventListeners.add(eventListener);
        return this;
    }

    public EventFiringWebDriver unregister(WebDriverEventListener eventListener) {
        this.eventListeners.remove(eventListener);
        return this;
    }

    public void get(String url) {
        this.dispatcher.beforeNavigateTo(url, this.driver);
        this.driver.get(url);
        this.dispatcher.afterNavigateTo(url, this.driver);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public boolean getVisible() {
        return this.driver.getVisible();
    }

    public void setVisible(boolean visible) {
        this.driver.setVisible(visible);
    }

    public List<WebElement> findElements(By by) {
        this.dispatcher.beforeFindBy(by, null, this.driver);
        List temp = this.driver.findElements(by);
        this.dispatcher.afterFindBy(by, null, this.driver);
        ArrayList<WebElement> result = new ArrayList<WebElement>(temp.size());
        for (WebElement element : temp) {
            result.add(new EventFiringWebElement(element));
        }
        return result;
    }

    public WebElement findElement(By by) {
        this.dispatcher.beforeFindBy(by, null, this.driver);
        WebElement temp = this.driver.findElement(by);
        this.dispatcher.afterFindBy(by, null, this.driver);
        return new EventFiringWebElement(temp);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Object executeScript(String script, Object ... args) {
        if (this.driver instanceof JavascriptExecutor) {
            this.dispatcher.beforeScript(script, this.driver);
            Object result = ((JavascriptExecutor)this.driver).executeScript(script, new Object[0]);
            this.dispatcher.afterScript(script, this.driver);
            return result;
        }
        throw new UnsupportedOperationException("Underlying driver instance does not support executing javascript");
    }

    public WebDriver.TargetLocator switchTo() {
        return new EventFiringTargetLocator(this.driver.switchTo());
    }

    public WebDriver.Navigation navigate() {
        return new EventFiringNavigation(this.driver.navigate());
    }

    public WebDriver.Options manage() {
        return new EventFiringOptions(this.driver.manage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventFiringTargetLocator
    implements WebDriver.TargetLocator {
        private WebDriver.TargetLocator targetLocator;

        private EventFiringTargetLocator(WebDriver.TargetLocator targetLocator) {
            this.targetLocator = targetLocator;
        }

        public WebDriver frame(int frameIndex) {
            return this.targetLocator.frame(frameIndex);
        }

        public WebDriver frame(String frameName) {
            return this.targetLocator.frame(frameName);
        }

        public WebDriver window(String windowName) {
            return this.targetLocator.window(windowName);
        }

        public Iterable<WebDriver> windowIterable() {
            return this.targetLocator.windowIterable();
        }

        public WebDriver defaultContent() {
            return this.targetLocator.defaultContent();
        }

        public WebElement activeElement() {
            return this.targetLocator.activeElement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventFiringOptions
    implements WebDriver.Options {
        private WebDriver.Options options;

        private EventFiringOptions(WebDriver.Options options) {
            this.options = options;
        }

        public void addCookie(Cookie cookie) {
            this.options.addCookie(cookie);
        }

        public void deleteCookieNamed(String name) {
            this.options.deleteCookieNamed(name);
        }

        public void deleteCookie(Cookie cookie) {
            this.options.deleteCookie(cookie);
        }

        public void deleteAllCookies() {
            this.options.deleteAllCookies();
        }

        public Set<Cookie> getCookies() {
            return this.options.getCookies();
        }

        public Speed getSpeed() {
            return this.options.getSpeed();
        }

        public void setSpeed(Speed speed) {
            this.options.setSpeed(speed);
        }
    }

    private class EventFiringNavigation
    implements WebDriver.Navigation {
        private final WebDriver.Navigation navigation;

        EventFiringNavigation(WebDriver.Navigation navigation) {
            this.navigation = navigation;
        }

        public void to(String url) {
            EventFiringWebDriver.this.dispatcher.beforeNavigateTo(url, EventFiringWebDriver.this.driver);
            this.navigation.to(url);
            EventFiringWebDriver.this.dispatcher.afterNavigateTo(url, EventFiringWebDriver.this.driver);
        }

        public void back() {
            EventFiringWebDriver.this.dispatcher.beforeNavigateBack(EventFiringWebDriver.this.driver);
            this.navigation.back();
            EventFiringWebDriver.this.dispatcher.afterNavigateBack(EventFiringWebDriver.this.driver);
        }

        public void forward() {
            EventFiringWebDriver.this.dispatcher.beforeNavigateForward(EventFiringWebDriver.this.driver);
            this.navigation.forward();
            EventFiringWebDriver.this.dispatcher.afterNavigateForward(EventFiringWebDriver.this.driver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventFiringWebElement
    implements WebElement {
        private final WebElement element;

        private EventFiringWebElement(WebElement element) {
            this.element = element;
        }

        public void click() {
            EventFiringWebDriver.this.dispatcher.beforeClickOn(this.element, EventFiringWebDriver.this.driver);
            this.element.click();
            EventFiringWebDriver.this.dispatcher.afterClickOn(this.element, EventFiringWebDriver.this.driver);
        }

        public void submit() {
            this.element.submit();
        }

        public String getValue() {
            return this.element.getValue();
        }

        public void sendKeys(CharSequence ... keysToSend) {
            EventFiringWebDriver.this.dispatcher.beforeChangeValueOf(this.element, EventFiringWebDriver.this.driver);
            this.element.sendKeys(keysToSend);
            EventFiringWebDriver.this.dispatcher.afterChangeValueOf(this.element, EventFiringWebDriver.this.driver);
        }

        public void clear() {
            EventFiringWebDriver.this.dispatcher.beforeChangeValueOf(this.element, EventFiringWebDriver.this.driver);
            this.element.clear();
            EventFiringWebDriver.this.dispatcher.afterChangeValueOf(this.element, EventFiringWebDriver.this.driver);
        }

        public String getElementName() {
            return this.element.getElementName();
        }

        public String getAttribute(String name) {
            return this.element.getAttribute(name);
        }

        public boolean toggle() {
            EventFiringWebDriver.this.dispatcher.beforeChangeValueOf(this.element, EventFiringWebDriver.this.driver);
            boolean result = this.element.toggle();
            EventFiringWebDriver.this.dispatcher.afterChangeValueOf(this.element, EventFiringWebDriver.this.driver);
            return result;
        }

        public boolean isSelected() {
            return this.element.isSelected();
        }

        public void setSelected() {
            this.element.setSelected();
        }

        public boolean isEnabled() {
            return this.element.isEnabled();
        }

        public String getText() {
            return this.element.getText();
        }

        public List<WebElement> getChildrenOfType(String tagName) {
            List elements = this.element.getChildrenOfType(tagName);
            ArrayList<WebElement> result = new ArrayList<WebElement>(elements.size());
            for (WebElement element : elements) {
                result.add(new EventFiringWebElement(element));
            }
            return result;
        }

        public WebElement findElement(By by) {
            EventFiringWebDriver.this.dispatcher.beforeFindBy(by, this.element, EventFiringWebDriver.this.driver);
            WebElement temp = this.element.findElement(by);
            EventFiringWebDriver.this.dispatcher.afterFindBy(by, this.element, EventFiringWebDriver.this.driver);
            return new EventFiringWebElement(temp);
        }

        public List<WebElement> findElements(By by) {
            EventFiringWebDriver.this.dispatcher.beforeFindBy(by, this.element, EventFiringWebDriver.this.driver);
            List temp = this.element.findElements(by);
            EventFiringWebDriver.this.dispatcher.afterFindBy(by, this.element, EventFiringWebDriver.this.driver);
            ArrayList<WebElement> result = new ArrayList<WebElement>(temp.size());
            for (WebElement element : temp) {
                result.add(new EventFiringWebElement(element));
            }
            return result;
        }
    }
}

