/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.openqa.selenium.By;
import org.openqa.selenium.How;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindBy;

public class LocatingElementHandler
implements InvocationHandler {
    private final WebDriver driver;
    private final By by;
    private final boolean cacheLookup;
    private WebElement element;

    public LocatingElementHandler(WebDriver driver, Field field) {
        this.driver = driver;
        this.by = this.buildBy(field);
        this.cacheLookup = this.isLookupCached(field);
    }

    private boolean isLookupCached(Field field) {
        return field.getAnnotation(CacheLookup.class) != null;
    }

    private By buildBy(Field field) {
        How how = How.ID_OR_NAME;
        String using = field.getName();
        FindBy findBy = field.getAnnotation(FindBy.class);
        if (findBy != null) {
            how = findBy.how();
            using = findBy.using();
        }
        switch (how) {
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element");
    }

    public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
        if (this.cacheLookup) {
            if (this.element == null) {
                this.element = this.driver.findElement(this.by);
            }
            return method.invoke((Object)this.element, objects);
        }
        WebElement use = this.driver.findElement(this.by);
        return method.invoke((Object)use, objects);
    }
}

