/*
 * Copyright 2008 Nokia Siemens Networks Oyj
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robotframework.javalib.util;

/**
 * @author Sami Honkonen
 */
public class KeywordNameNormalizer implements IKeywordNameNormalizer {
    /**
     * Normalizes a keyword name. Removes spaces and special characters.
     * Converts all letters to lower case.
     *
     * @param keywordName keyword name
     * @return normalized keyword name
     */
    public String normalize(String keywordName) {
        keywordName = keywordName.toLowerCase().trim();
        keywordName = keywordName.replaceAll(" ", "");
        keywordName = keywordName.replaceAll("_", "");
        keywordName = keywordName.replaceAll("\t", "");
        keywordName = keywordName.replaceAll("\r", "");
        keywordName = keywordName.replaceAll("\n", "");
        return keywordName;
    }
}
