/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.factory;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotNullPredicate;
import org.apache.commons.collections.list.PredicatedList;
import org.apache.commons.collections.list.SetUniqueList;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.CollisionKeyword;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.javalib.keyword.KeywordMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeKeywordFactory
implements KeywordFactory<Keyword> {
    private List keywordFactories = CompositeKeywordFactory.createUniqueListThatDoesntAcceptNullValues();
    private KeywordMap keywordNamesAndTheirFactories = new KeywordMap();
    private KeywordMap collidingKeywords = new KeywordMap();

    @Override
    public Keyword createKeyword(String keywordName) {
        if (this.isCollidingKeyword(keywordName)) {
            Keyword keyword = (Keyword)this.collidingKeywords.get(keywordName);
            return keyword;
        }
        KeywordFactory<Keyword> factory = this.getKeywordFactory(keywordName);
        return factory.createKeyword(keywordName);
    }

    @Override
    public String[] getKeywordNames() {
        return this.keywordNamesAndTheirFactories.getKeywordNames();
    }

    public synchronized void addKeywordFactory(KeywordFactory factory) {
        int factoryNumber = this.keywordFactories.size();
        this.addKeywordNamesToTable(factory, factoryNumber);
        this.keywordFactories.add(factory);
    }

    public KeywordFactory[] getKeywordFactories() {
        return this.keywordFactories.toArray(new KeywordFactory[0]);
    }

    private boolean isCollidingKeyword(String keywordName) {
        return this.collidingKeywords.containsKeyword(keywordName);
    }

    private KeywordFactory<Keyword> getKeywordFactory(String keywordName) {
        int factoryNumber = (Integer)this.keywordNamesAndTheirFactories.get(keywordName);
        KeywordFactory factory = (KeywordFactory)this.keywordFactories.get(factoryNumber);
        return factory;
    }

    private void handleDuplicateKeyword(KeywordFactory keywordFactory, String keywordName) {
        if (this.alreadyAConflictingKeyword(keywordName)) {
            return;
        }
        KeywordFactory<Keyword> alreadyAddedKeywordFactory = this.getKeywordFactory(keywordName);
        Keyword keyword1 = alreadyAddedKeywordFactory.createKeyword(keywordName);
        Object keyword2 = keywordFactory.createKeyword(keywordName);
        this.collidingKeywords.add(keywordName, new CollisionKeyword(keyword1.getClass().toString(), keyword2.getClass().toString()));
    }

    private boolean alreadyAConflictingKeyword(String keywordName) {
        return this.collidingKeywords.containsKeyword(keywordName);
    }

    private void addKeywordNamesToTable(KeywordFactory keywordFactory, int factoryNumber) {
        String[] keywordNames = keywordFactory.getKeywordNames();
        for (int i = 0; i < keywordNames.length; ++i) {
            String keywordName = keywordNames[i];
            if (this.keywordAlreadyExists(keywordName)) {
                this.handleDuplicateKeyword(keywordFactory, keywordName);
                continue;
            }
            this.keywordNamesAndTheirFactories.add(keywordName, new Integer(factoryNumber));
        }
    }

    private boolean keywordAlreadyExists(String keywordName) {
        return this.keywordNamesAndTheirFactories.containsKeyword(keywordName);
    }

    private static List createUniqueListThatDoesntAcceptNullValues() {
        Object list = new ArrayList();
        list = SetUniqueList.decorate(list);
        list = PredicatedList.decorate((List)list, (Predicate)NotNullPredicate.INSTANCE);
        return list;
    }
}

