/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.library;

import java.lang.reflect.InvocationTargetException;
import org.robotframework.javalib.beans.annotation.AnnotationBasedKeywordFilter;
import org.robotframework.javalib.beans.annotation.IBeanLoader;
import org.robotframework.javalib.beans.annotation.KeywordBeanLoader;
import org.robotframework.javalib.beans.common.IClassFilter;
import org.robotframework.javalib.factory.AnnotationKeywordFactory;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.DocumentedKeyword;
import org.robotframework.javalib.library.KeywordDocumentationRepository;
import org.robotframework.javalib.library.KeywordFactoryBasedLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationLibrary
extends KeywordFactoryBasedLibrary<DocumentedKeyword>
implements KeywordDocumentationRepository {
    private IBeanLoader beanLoader;
    private IClassFilter classFilter = new AnnotationBasedKeywordFilter();
    private KeywordFactory<DocumentedKeyword> keywordFactory;

    public AnnotationLibrary() {
    }

    public AnnotationLibrary(String keywordPattern) {
        this.setKeywordPattern(keywordPattern);
    }

    @Override
    protected KeywordFactory<DocumentedKeyword> createKeywordFactory() {
        this.assumeKeywordPatternIsSet();
        if (this.keywordFactory == null) {
            this.keywordFactory = new AnnotationKeywordFactory(this.beanLoader.loadBeanDefinitions(this.classFilter));
        }
        return this.keywordFactory;
    }

    @Override
    public String[] getKeywordArguments(String keywordName) {
        return this.createKeywordFactory().createKeyword(keywordName).getArgumentNames();
    }

    @Override
    public String getKeywordDocumentation(String keywordName) {
        return this.createKeywordFactory().createKeyword(keywordName).getDocumentation();
    }

    @Override
    public Object runKeyword(String keywordName, Object[] args) {
        try {
            return super.runKeyword(keywordName, args);
        }
        catch (RuntimeException e) {
            throw this.retrieveInnerException(e);
        }
    }

    public void setKeywordPattern(String keywordPattern) {
        this.beanLoader = new KeywordBeanLoader(keywordPattern);
    }

    private void assumeKeywordPatternIsSet() {
        if (this.beanLoader == null) {
            throw new IllegalStateException("Keyword pattern must be set before calling getKeywordNames.");
        }
    }

    private RuntimeException retrieveInnerException(RuntimeException e) {
        Throwable cause = e.getCause();
        if (InvocationTargetException.class.equals(cause.getClass())) {
            Throwable original = cause.getCause();
            return new RuntimeException(original.getMessage(), original);
        }
        return e;
    }
}

