/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static boolean arrayContains(String needle, String[] haystack) {
        for (int i = 0; i < haystack.length; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return true;
        }
        return false;
    }

    public static void assertArraysContainSame(String[] expected, String[] actual) {
        Assert.assertEquals(new HashSet<String>(Arrays.asList(expected)), new HashSet<String>(Arrays.asList(actual)));
    }

    public static <T> void assertArraysEquals(T[] expected, T[] actual) {
        Assert.assertTrue((String)("Expected " + Arrays.asList(expected) + " but was " + Arrays.asList(actual)), (boolean)Arrays.equals(expected, actual));
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return ArrayUtil.copyOfRange(original, from, to, original.getClass());
    }
}

