/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.beans.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.JarFile;
import org.robotframework.javalib.beans.common.ClassFinder;
import org.robotframework.javalib.beans.common.ClassNameResolver;
import org.robotframework.javalib.beans.common.DefaultClassNameResolver;
import org.robotframework.javalib.beans.common.URLFileFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DefaultClassFinder
extends PathMatchingResourcePatternResolver
implements ClassFinder {
    private ClassNameResolver classNameResolver;
    private URLFileFactory urlFileFactory = new URLFileFactory(System.getProperty("java.io.tmpdir"));

    public DefaultClassFinder(ClassLoader classLoader) {
        super(classLoader);
        this.classNameResolver = new DefaultClassNameResolver();
    }

    public DefaultClassFinder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public Class[] getClasses(String pattern) {
        Resource[] resources = this.findResources(pattern);
        ArrayList<Class> classes = new ArrayList<Class>();
        for (int i = 0; i < resources.length; ++i) {
            String className = this.classNameResolver.resolveClassName(resources[i], this.determinePackageRoot(pattern));
            classes.add(this.loadClass(className));
        }
        return classes.toArray(new Class[0]);
    }

    public void setClassNameResolver(ClassNameResolver classNameResolver) {
        this.classNameResolver = classNameResolver;
    }

    private String determinePackageRoot(String location) {
        String rootDir = this.determineRootDir(location);
        return rootDir.substring(rootDir.indexOf(":") + 1);
    }

    private Class loadClass(String className) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Resource[] findResources(String pattern) {
        try {
            return this.getResources(pattern);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        if (this.isURLResource(jarFileUrl)) {
            File fileFromUrl = this.urlFileFactory.createFileFromUrl(jarFileUrl);
            return this.createJarFile(fileFromUrl);
        }
        return super.getJarFile(jarFileUrl);
    }

    JarFile createJarFile(File fileFromUrl) throws IOException {
        return new JarFile(fileFromUrl);
    }

    private boolean isURLResource(String jarFileUrl) {
        return jarFileUrl.toLowerCase().startsWith("http");
    }
}

