/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Properties;
import org.robotframework.javalib.util.NullPrintStream;

public class Logger {
    private static PrintStream out = System.out;

    public static void setOut(PrintStream out) {
        Logger.out = out;
    }

    public static void log(Object message) {
        out.println("[" + Logger.callPoint() + "] [" + Logger.getTimestamp() + "] " + message.toString());
    }

    private static String getTimestamp() {
        Calendar cal = Calendar.getInstance();
        return cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
    }

    private static StackTraceElement callPoint() {
        return Thread.currentThread().getStackTrace()[3];
    }

    private static Properties loadProperties(String name) {
        Properties properties = new Properties();
        InputStream resourceAsStream = Logger.class.getResourceAsStream(name);
        if (resourceAsStream != null) {
            return Logger.loadProperties(properties, resourceAsStream);
        }
        return properties;
    }

    private static Properties loadProperties(Properties properties, InputStream resourceAsStream) {
        try {
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    private static PrintStream createOutStream(String logFile, boolean append) {
        if (logFile == null || logFile.length() == 0) {
            return new NullPrintStream();
        }
        try {
            return new PrintStream(new FileOutputStream(logFile, append), true);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("logFile " + logFile + " could not be created", e);
        }
    }

    static {
        Properties props = Logger.loadProperties("/logging.properties");
        String logFile = props.getProperty("logFile", "");
        boolean append = Boolean.parseBoolean(props.getProperty("append", "false"));
        PrintStream outStream = Logger.createOutStream(logFile, append);
        Logger.setOut(outStream);
    }
}

