/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.beans.common;

import java.io.IOException;
import org.robotframework.javalib.beans.common.ClassNameResolver;
import org.springframework.core.io.Resource;

public class DefaultClassNameResolver
implements ClassNameResolver {
    public String resolveClassName(Resource resource, String packagePrefix) {
        String packagePrefixPath = packagePrefix.replace('.', '/');
        String fileSystemPath = this.determineFileSystemPath(resource);
        int index = fileSystemPath.lastIndexOf(packagePrefixPath);
        return this.convertToClassName(fileSystemPath.substring(index));
    }

    private String convertToClassName(String classLocation) {
        int index = classLocation.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("Couldn't convert class location <" + classLocation + "> to class name");
        }
        classLocation = classLocation.substring(0, index);
        return classLocation.replaceAll("/", ".");
    }

    private String determineFileSystemPath(Resource resource) {
        try {
            return resource.getURL().getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't determine filesystem path for resource <" + resource + ">", e);
        }
    }
}

