/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.beans.common;

import org.robotframework.javalib.beans.common.ClassFinder;
import org.robotframework.javalib.beans.common.DefaultClassFinder;
import org.robotframework.javalib.beans.common.IClassFilter;
import org.robotframework.javalib.beans.common.IKeywordBeanDefintionReader;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class KeywordBeanDefinitionReader
implements IKeywordBeanDefintionReader {
    private ClassFinder classFinder;
    private BeanDefinitionRegistry registry;

    public KeywordBeanDefinitionReader(BeanDefinitionRegistry registry, ClassLoader classLoader) {
        this.registry = registry;
        this.classFinder = new DefaultClassFinder(classLoader);
    }

    public int loadBeanDefinitions(String pattern, IClassFilter filter) {
        int acceptedClasses = 0;
        Class[] classes = this.classFinder.getClasses("classpath*:" + pattern);
        for (int i = 0; i < classes.length; ++i) {
            Class clazz = classes[i];
            if (!filter.accept(clazz)) continue;
            this.registerKeywordBean(clazz);
            ++acceptedClasses;
        }
        return acceptedClasses;
    }

    public void setClassFinder(ClassFinder classFinder) {
        this.classFinder = classFinder;
    }

    private void registerKeywordBean(Class clazz) {
        String keywordName = this.extractKeywordName(clazz.getName());
        RootBeanDefinition beanDefinition = new RootBeanDefinition(clazz);
        this.registry.registerBeanDefinition(keywordName, (BeanDefinition)beanDefinition);
    }

    private String extractKeywordName(String className) {
        int index = className.lastIndexOf(".");
        return className.substring(index + 1);
    }
}

