/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.beans.spring;

import java.io.IOException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class KeywordsXmlBeanDefinitionReader {
    private ResourcePatternResolver resourcePatternResolver;
    private BeanDefinitionRegistry registry;

    public KeywordsXmlBeanDefinitionReader(BeanDefinitionRegistry registry, ClassLoader classLoader) {
        this.registry = registry;
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver(classLoader);
    }

    public int loadBeanDefinitions(String pattern) {
        Resource[] configurationFiles = this.getConfigurationFiles(pattern);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(this.registry);
        return reader.loadBeanDefinitions(configurationFiles);
    }

    private Resource[] getConfigurationFiles(String pattern) {
        try {
            return this.resourcePatternResolver.getResources("classpath*:" + pattern);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setResourcePatternResolver(ResourcePatternResolver resolver) {
        this.resourcePatternResolver = resolver;
    }
}

