/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.context;

import org.robotframework.javalib.util.IKeywordNameNormalizer;
import org.robotframework.javalib.util.KeywordNameNormalizer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.support.GenericApplicationContext;

public class KeywordApplicationContext
extends GenericApplicationContext {
    private IKeywordNameNormalizer keywordNameNormalizer = new KeywordNameNormalizer();

    public KeywordApplicationContext() {
        super(new DefaultListableBeanFactory(){

            public void preInstantiateSingletons() throws BeansException {
            }
        });
    }

    public void registerBeanDefinition(String name, BeanDefinition beanDefinition) throws BeansException {
        String normalizedName = this.keywordNameNormalizer.normalize(name);
        super.registerBeanDefinition(name, beanDefinition);
        this.registerAlias(name, normalizedName);
    }

    public Object getBean(String name) throws BeansException {
        return super.getBean(this.keywordNameNormalizer.normalize(name));
    }

    public String[] getBeanNamesForType(Class type) {
        String[] beanNames = super.getBeanNamesForType(type);
        for (int i = 0; i < beanNames.length; ++i) {
            beanNames[i] = this.keywordNameNormalizer.normalize(beanNames[i]);
        }
        return beanNames;
    }
}

