/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.library;

import org.robotframework.javalib.factory.CompositeKeywordFactory;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.javalib.library.AnnotationLibrary;
import org.robotframework.javalib.library.ClassPathLibrary;
import org.robotframework.javalib.library.KeywordFactoryBasedLibrary;
import org.robotframework.javalib.library.SpringLibrary;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeLibrary
extends KeywordFactoryBasedLibrary<Keyword> {
    private String keywordPattern;
    private String configFilePattern;
    private boolean needToSetKeywordPattern;
    private boolean needToSetConfigFilePattern;

    public CompositeLibrary() {
    }

    public CompositeLibrary(String keywordPattern, String configFilePattern) {
        this.setKeywordPattern(keywordPattern);
        this.setConfigFilePattern(configFilePattern);
    }

    @Override
    protected KeywordFactory<Keyword> createKeywordFactory() {
        SpringLibrary springLibrary = new SpringLibrary();
        springLibrary.setClassLoader(this.getClassLoader());
        if (this.needToSetConfigFilePattern) {
            springLibrary.setConfigFilePattern(this.configFilePattern);
        }
        AnnotationLibrary annotationLibrary = new AnnotationLibrary();
        ClassPathLibrary classPathLibrary = new ClassPathLibrary();
        classPathLibrary.setClassLoader(this.getClassLoader());
        if (this.needToSetKeywordPattern) {
            classPathLibrary.setKeywordPattern(this.keywordPattern);
            annotationLibrary.addKeywordPattern(this.keywordPattern);
        }
        CompositeKeywordFactory factory = new CompositeKeywordFactory();
        factory.addKeywordFactory(springLibrary.createKeywordFactory());
        factory.addKeywordFactory(classPathLibrary.createKeywordFactory());
        factory.addKeywordFactory(annotationLibrary.createKeywordFactory());
        return factory;
    }

    public void setKeywordPattern(String pattern) {
        this.needToSetKeywordPattern = true;
        this.keywordPattern = pattern;
    }

    public void setConfigFilePattern(String pattern) {
        this.needToSetConfigFilePattern = true;
        this.configFilePattern = pattern;
    }
}

