/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robotframework.javalib.beans.annotation.AnnotationKeywordExtractor;
import org.robotframework.javalib.beans.annotation.IKeywordExtractor;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.DocumentedKeyword;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.javalib.util.IKeywordNameNormalizer;
import org.robotframework.javalib.util.KeywordNameNormalizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationKeywordFactory
implements KeywordFactory<DocumentedKeyword> {
    private Map<String, DocumentedKeyword> keywords = new HashMap<String, DocumentedKeyword>();
    private IKeywordNameNormalizer keywordNameNormalizer = new KeywordNameNormalizer();
    private List<String> keywordNames = new ArrayList<String>();

    public AnnotationKeywordFactory(Map<String, Object> keywordBeansMap) {
        this.extractKeywordsFromKeywordBeans(keywordBeansMap);
    }

    @Override
    public DocumentedKeyword createKeyword(String keywordName) {
        String normalizedKeywordName = this.keywordNameNormalizer.normalize(keywordName);
        return this.keywords.get(normalizedKeywordName);
    }

    @Override
    public String[] getKeywordNames() {
        return this.keywordNames.toArray(new String[0]);
    }

    protected void extractKeywordsFromKeywordBeans(Map<String, Object> keywordBeansMap) {
        Collection<Object> keywordBeanValues = keywordBeansMap.values();
        IKeywordExtractor<DocumentedKeyword> keywordExtractor = this.createKeywordExtractor();
        for (Object keywordBean : keywordBeanValues) {
            Map<String, DocumentedKeyword> extractedKeywords = keywordExtractor.extractKeywords(keywordBean);
            this.addKeywordNames(extractedKeywords);
            this.addKeywords(extractedKeywords);
        }
    }

    IKeywordExtractor<DocumentedKeyword> createKeywordExtractor() {
        return new AnnotationKeywordExtractor();
    }

    private void addKeywords(Map<String, DocumentedKeyword> extractedKeywords) {
        for (String keywordName : extractedKeywords.keySet()) {
            this.keywords.put(this.keywordNameNormalizer.normalize(keywordName), extractedKeywords.get(keywordName));
        }
    }

    private void addKeywordNames(Map<String, DocumentedKeyword> extractedKeywords) {
        this.keywordNames.addAll(extractedKeywords.keySet());
    }

    @Override
    public /* synthetic */ Keyword createKeyword(String x0) {
        return this.createKeyword(x0);
    }
}

